/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.doms.summa;

import dk.statsbiblioteket.doms.summa.SummaStorageDriver;
import dk.statsbiblioteket.doms.summa.oai.Client;
import dk.statsbiblioteket.doms.summa.oai.ListRecordsResponse;
import dk.statsbiblioteket.doms.summa.oai.OAIDateFormat;
import dk.statsbiblioteket.doms.summa.oai.Request;
import dk.statsbiblioteket.sbandex.storage.io.Access;
import dk.statsbiblioteket.sbandex.storage.io.Control;
import dk.statsbiblioteket.sbandex.storage.io.Record;
import dk.statsbiblioteket.sbandex.storage.io.RecordAndNext;
import dk.statsbiblioteket.sbandex.storage.io.RecordIterator;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SummaStorage
extends Control {
    private static final Log log = LogFactory.getLog(SummaStorage.class);
    private Client oaiClient = new Client(SummaStorageDriver.OAI_PROVIDER);
    private long currentIterKey = 0L;
    private Map<Long, Iterator<Record>> iterators = new HashMap<Long, Iterator<Record>>();
    private OAIDateFormat dateFormatter = new OAIDateFormat();

    public SummaStorage() throws RemoteException {
        super(SummaStorageDriver.RMI_PORT);
    }

    public RecordIterator getRecords(String base) throws RemoteException {
        Request rq = new Request();
        rq.addVerb("ListRecords");
        rq.addMetadataPrefix(SummaStorageDriver.METADATA_PREFIX);
        if (!SummaStorageDriver.ALL_RECORDS_IDENTIFIER.equals(base)) {
            rq.add("setOps", base);
        }
        try {
            ListRecordsResponse resp = (ListRecordsResponse)this.oaiClient.submit(rq);
            return this.createRecordIterator(resp);
        }
        catch (IOException e) {
            throw new RemoteException("Failed to submit OAI request: " + rq, e);
        }
    }

    public RecordIterator getRecordsModifiedAfter(long time, String base) throws RemoteException {
        Request rq = new Request();
        rq.addVerb("ListRecords");
        rq.addMetadataPrefix(SummaStorageDriver.METADATA_PREFIX);
        rq.add("from", this.dateFormatter.format(new Date(time)));
        if (!SummaStorageDriver.ALL_RECORDS_IDENTIFIER.equals(base)) {
            rq.add("setOps", base);
        }
        try {
            ListRecordsResponse resp = (ListRecordsResponse)this.oaiClient.submit(rq);
            return this.createRecordIterator(resp);
        }
        catch (IOException e) {
            throw new RemoteException("Failed to submit OAI request: " + rq, e);
        }
    }

    public RecordIterator getRecordsFrom(String name, String base) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public RecordIterator[] getSplits(int splits, String base) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public Record getRecord(String name) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public Record createNewRecord(String name, String base) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public Record createNewRecord(String name, byte[] data, String base) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public boolean deleteRecord(String name) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void removeDeletedBefore(long time, String base) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void updateRecord(Record record) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void updateRecord(String name, byte[] data) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public boolean recordExists(String name) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public boolean recordActive(String name) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public RecordAndNext next(Long iteratorKey) throws RemoteException {
        Iterator<Record> iter = this.iterators.get(iteratorKey);
        Record record = iter.next();
        return new RecordAndNext(record, iter.hasNext());
    }

    public void perform() {
        throw new UnsupportedOperationException();
    }

    public void exportRMIInterface() throws RemoteException {
        try {
            Registry reg = LocateRegistry.createRegistry(SummaStorageDriver.REGISTRY_PORT);
            log.info((Object)("Created registry on port " + SummaStorageDriver.REGISTRY_PORT));
            try {
                reg.rebind(SummaStorageDriver.SERVICE_NAME, (Remote)((Object)this));
            }
            catch (RemoteException ee) {
                log.error((Object)"Failed to bind in registry", (Throwable)ee);
                throw ee;
            }
        }
        catch (RemoteException e) {
            log.error((Object)"Failed to create registry: ", (Throwable)e);
            throw e;
        }
        log.info((Object)((Object)((Object)this) + " bound in registry as '" + SummaStorageDriver.SERVICE_NAME + "' on port " + SummaStorageDriver.REGISTRY_PORT));
    }

    private RecordIterator createRecordIterator(ListRecordsResponse response) {
        response.parse();
        long key = this.currentIterKey++;
        Iterator<Record> iter = response.iterator();
        this.iterators.put(key, iter);
        return new RecordIterator((Access)this, Long.valueOf(key), iter.hasNext());
    }
}

