/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.doms.summa.oai;

import dk.statsbiblioteket.doms.summa.oai.IdentifyResponse;
import dk.statsbiblioteket.doms.summa.oai.ListRecordsResponse;
import dk.statsbiblioteket.doms.summa.oai.Request;
import dk.statsbiblioteket.doms.summa.oai.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Client {
    private final Log log = LogFactory.getLog(Client.class);
    private String base;

    public Client(String oaiBaseUrl) {
        this.base = oaiBaseUrl.endsWith("/") ? oaiBaseUrl : oaiBaseUrl + "/";
    }

    public Response submit(Request rq) throws IOException {
        Response resp;
        MonitoredInputStream in = this.getInputStream(rq);
        String verb = rq.getToken("verb");
        if ("ListRecords".equals(verb)) {
            resp = new ListRecordsResponse(in, this.getIdentity());
        } else if ("Identify".equals(verb)) {
            resp = new IdentifyResponse(in);
        } else {
            throw new RuntimeException("Unknown verb: " + verb);
        }
        return resp;
    }

    private MonitoredInputStream getInputStream(Request rq) throws IOException {
        HttpURLConnection con;
        String url = this.base + "?" + rq;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Requesting URL: " + url));
        }
        try {
            con = (HttpURLConnection)new URL(url).openConnection();
            con.connect();
        }
        catch (MalformedURLException e) {
            throw new IOException(e.toString());
        }
        return new MonitoredInputStream(con);
    }

    private IdentifyResponse getIdentity() throws IOException {
        Request rq = new Request();
        rq.addVerb("Identify");
        IdentifyResponse resp = (IdentifyResponse)this.submit(rq);
        try {
            return (IdentifyResponse)resp.parse();
        }
        catch (ParseException e) {
            throw new IOException("Unable to read Identity information");
        }
    }

    private class MonitoredInputStream
    extends BufferedInputStream {
        private HttpURLConnection con;

        public MonitoredInputStream(HttpURLConnection connection) throws IOException {
            super(connection.getInputStream());
            this.con = connection;
        }

        public void close() throws IOException {
            super.close();
            this.con.disconnect();
        }
    }
}

