/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.doms.summa.oai;

import dk.statsbiblioteket.doms.summa.oai.Client;
import dk.statsbiblioteket.doms.summa.oai.IdentifyResponse;
import dk.statsbiblioteket.doms.summa.oai.ListRecordsResponseSAXParser;
import dk.statsbiblioteket.doms.summa.oai.Request;
import dk.statsbiblioteket.doms.summa.oai.Response;
import dk.statsbiblioteket.sbandex.storage.io.Record;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRecordsResponse
extends Response
implements Iterable<Record> {
    private final Log log = LogFactory.getLog(ListRecordsResponse.class);
    private String responseDate;
    private String serviceURL;
    private String verb;
    private String resumptionToken;
    ListRecordsResponseSAXParser parser;
    private IdentifyResponse id;

    public ListRecordsResponse(InputStream in, IdentifyResponse id) {
        super(in);
        this.id = id;
    }

    @Override
    public Response parse() {
        this.parser = new ListRecordsResponseSAXParser(this, this.id);
        this.parser.parse();
        this.responseDate = this.parser.getResponseDate();
        this.serviceURL = this.parser.getServiceURL();
        this.verb = this.parser.getVerb();
        this.resumptionToken = this.parser.getResumptionToken();
        return this;
    }

    @Override
    public String getResponseDate() {
        return this.responseDate;
    }

    @Override
    public String getVerb() {
        return this.verb;
    }

    @Override
    public String getServiceURL() {
        return this.serviceURL;
    }

    @Override
    public Iterator<Record> iterator() {
        return new ResumingIterator(this.parser);
    }

    @Override
    public String getResumptionToken() {
        return this.resumptionToken;
    }

    @Override
    public boolean isParsing() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResumingIterator
    implements Iterator<Record> {
        private ListRecordsResponseSAXParser currentParser;
        private Iterator<Record> currentIter;

        public ResumingIterator(ListRecordsResponseSAXParser firstParser) {
            this.currentParser = firstParser;
            this.currentIter = this.currentParser.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIter.hasNext()) {
                return true;
            }
            if ("".equals(this.currentParser.getResumptionToken())) {
                return false;
            }
            this.currentParser = this.nextParser();
            this.currentIter = this.currentParser.iterator();
            return this.hasNext();
        }

        @Override
        public Record next() {
            return this.currentIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private ListRecordsResponseSAXParser nextParser() {
            Client client = new Client(this.currentParser.getServiceURL());
            Request rq = new Request();
            rq.addVerb(this.currentParser.getVerb());
            rq.add("resumptionToken", this.currentParser.getResumptionToken());
            try {
                ListRecordsResponse res = (ListRecordsResponse)client.submit(rq);
                ListRecordsResponseSAXParser newParser = new ListRecordsResponseSAXParser(res, ListRecordsResponse.this.id);
                ListRecordsResponse.this.log.info((Object)("Got response for ListRecords request on resumption token: \"" + this.currentParser.getResumptionToken() + "\""));
                newParser.parse();
                ListRecordsResponse.this.log.debug((Object)"Parsed response for ListRecords request");
                return newParser;
            }
            catch (IOException e) {
                ListRecordsResponse.this.log.error((Object)("Failed to resume ListRecords request on resumption token: \"" + this.currentParser.getResumptionToken() + "\""), (Throwable)e);
                return null;
            }
        }
    }
}

