/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.doms.summa.oai;

import dk.statsbiblioteket.doms.summa.oai.IdentifyResponse;
import dk.statsbiblioteket.doms.summa.oai.OAIDateFormat;
import dk.statsbiblioteket.doms.summa.oai.Response;
import dk.statsbiblioteket.sbandex.storage.io.Record;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRecordsResponseSAXParser
extends DefaultHandler2
implements Iterable<Record> {
    private static final String recordLead = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    public static final String DEFAULT_NAMESPACE = "http://www.openarchives.org/OAI/2.0/";
    public static final String DUBLINCORE_NAMESPACE = "http://purl.org/dc/elements/1.1/";
    public static final String OAI_DC_NAMESPACE = "http://www.openarchives.org/OAI/2.0/oai_dc/";
    public static final String XSI_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private OAIDateFormat dateFormat;
    private int namespaceNumerator = 1;
    private Log log = LogFactory.getLog(ListRecordsResponseSAXParser.class);
    protected StringBuffer buf;
    protected Map<String, String> namespace;
    protected ArrayBlockingQueue<Record> q;
    private Response response;
    protected boolean inRecord;
    protected boolean inHeader;
    protected boolean inResponseDate;
    protected boolean inRequest;
    protected boolean inIdentifier;
    protected boolean inDateStamp;
    protected boolean inResumptionToken;
    private String _currentID;
    private String _currentDate;
    private Record.State _currentState;
    private String responseDate;
    private String serviceURL;
    private String verb;
    private String resumptionToken;
    private IdentifyResponse targetID;

    public ListRecordsResponseSAXParser(Response response, IdentifyResponse id) {
        this.response = response;
        this.targetID = id;
        this.q = new ArrayBlockingQueue(5000);
        this.namespace = new HashMap<String, String>();
        this.namespace.put(DEFAULT_NAMESPACE, "");
        this.namespace.put(DUBLINCORE_NAMESPACE, "dc:");
        this.namespace.put(OAI_DC_NAMESPACE, "oai_dc:");
        this.namespace.put(XSI_SCHEMA_INSTANCE, "xsi:");
        this.clearBuffers();
        this.responseDate = "";
        this.serviceURL = "";
        this.verb = "";
        this.resumptionToken = "";
        this.dateFormat = new OAIDateFormat();
    }

    public void parse() {
        try {
            XMLFilterImpl fil = new XMLFilterImpl();
            fil.setParent(XMLReaderFactory.createXMLReader());
            fil.setContentHandler(this);
            fil.parse(new InputSource(this.response.getInputStream()));
        }
        catch (Exception e) {
            this.log.error((Object)"Error parsing input stream", (Throwable)e);
            throw new RuntimeException("Error parsing input stream", e);
        }
    }

    @Override
    public Iterator<Record> iterator() {
        return new ResultSetIterator();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int i;
        if (DEFAULT_NAMESPACE.equals(uri) && "record".equals(localName)) {
            this.inRecord = true;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "identifier".equals(localName) && this.inHeader) {
            this.inIdentifier = true;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "datestamp".equals(localName) && this.inHeader) {
            this.inDateStamp = true;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "responseDate".equals(localName) && !this.inRecord) {
            this.inResponseDate = true;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "request".equals(localName) && !this.inRecord) {
            this.inRequest = true;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "resumptionToken".equals(localName) && !this.inRecord) {
            this.inResumptionToken = true;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "header".equals(localName)) {
            this.inHeader = true;
            for (i = 0; i < atts.getLength(); ++i) {
                if (!"status".equals(atts.getLocalName(i)) || !"deleted".equals(atts.getValue(i))) continue;
                this._currentState = Record.State.DELETED;
            }
        }
        if (this.inRecord && !"record".equals(localName)) {
            this.buf.append('<').append(this.getPrefix(uri)).append(localName);
            for (i = 0; i < atts.getLength(); ++i) {
                if (atts.getURI(i) != null && !"".equals(atts.getURI(i))) {
                    this.buf.append(' ').append(this.getPrefix(atts.getURI(i))).append(atts.getLocalName(i)).append('=').append('\"').append(this.xmlEncodeString(atts.getValue(i))).append('\"');
                    continue;
                }
                this.buf.append(' ').append(atts.getLocalName(i)).append('=').append('\"').append(this.xmlEncodeString(atts.getValue(i))).append('\"');
            }
            this.buf.append('>');
        } else if (this.inRequest) {
            this.verb = atts.getValue("verb");
        }
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.log.trace((Object)("in end elementhttp://www.openarchives.org/OAI/2.0/:" + uri + ";" + "record" + ":" + localName + " inRecord:" + this.inRecord));
        if (DEFAULT_NAMESPACE.equals(uri) && "identifier".equals(localName)) {
            this.inIdentifier = false;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "datestamp".equals(localName)) {
            this.inDateStamp = false;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "header".equals(localName)) {
            this.inHeader = false;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "responseDate".equals(localName)) {
            this.inResponseDate = false;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "request".equals(localName)) {
            this.inRequest = false;
        } else if (DEFAULT_NAMESPACE.equals(uri) && "resumptionToken".equals(localName)) {
            this.inResumptionToken = false;
        }
        if (this.inRecord) {
            this.buf.append('<').append('/').append(this.getPrefix(uri)).append(localName).append(">");
        }
        if (DEFAULT_NAMESPACE.equals(uri) && "record".equals(localName)) {
            byte[] content = null;
            StringBuffer leadin = new StringBuffer();
            try {
                leadin.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                leadin.append("<record OAItargetID=\"").append(this.targetID.getBaseURL()).append("\" OAItargetName=\"").append(this.targetID.getRepositoryName()).append("\"");
                leadin.append(" xmlns=\"http://www.openarchives.org/OAI/2.0/\"");
                for (Map.Entry<String, String> e : this.namespace.entrySet()) {
                    if ("".equals(e.getValue())) continue;
                    leadin.append(" xmlns:").append(e.getValue().substring(0, e.getValue().length() - 1)).append("=\"").append(e.getKey()).append("\"");
                }
                content = (leadin.toString() + ">" + this.buf.toString()).getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.fatal((Object)e.getMessage(), (Throwable)e);
                System.exit(-1);
            }
            try {
                this.q.put(new Record(this._currentID, content, this.dateFormat.timeStamp(this._currentDate), this._currentState, "MyRepository"));
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Interrupted while enqueuing Record", (Throwable)e);
            }
            catch (ParseException e) {
                this.log.error((Object)"Error parsing record date stamp", (Throwable)e);
            }
            this.clearBuffers();
        }
        if (DEFAULT_NAMESPACE.equals(uri) && "ListRecords".equals(localName)) {
            try {
                this.q.put(new IteratorTerminator());
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Interrupted while enqueuing IteratorTerminator", (Throwable)e);
            }
        }
        super.endElement(uri, localName, qName);
    }

    protected String xmlEscapeChars(char[] c, int start, int len) {
        String s = new String(c, start, len);
        s = this.xmlEncodeString(s);
        return s;
    }

    protected String xmlEncodeString(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("\"", "&quot;");
        return s;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = this.xmlEscapeChars(ch, start, length);
        if (this.inRecord) {
            this.buf.append(s);
        }
        if (this.inIdentifier) {
            this._currentID = this._currentID + s;
        } else if (this.inDateStamp) {
            this._currentDate = this._currentDate + s;
        } else if (this.inResponseDate) {
            this.responseDate = this.responseDate + s;
        } else if (this.inRequest) {
            this.serviceURL = this.serviceURL + s;
        } else if (this.inResumptionToken) {
            this.resumptionToken = this.resumptionToken + s;
        }
        super.characters(ch, start, length);
    }

    private void clearBuffers() {
        this.buf = new StringBuffer();
        this.inRecord = false;
        this.inHeader = false;
        this.inResponseDate = false;
        this.inRequest = false;
        this.inIdentifier = false;
        this.inDateStamp = false;
        this.inResumptionToken = false;
        this._currentDate = "";
        this._currentID = "";
        this._currentState = Record.State.STANDARD;
    }

    protected String getPrefix(String uri) {
        String f = this.namespace.get(uri);
        if (f == null && uri != null && !uri.trim().equals("")) {
            f = "n" + this.namespaceNumerator++ + ":";
            this.namespace.put(uri, f);
        }
        return f == null ? "" : f;
    }

    public String getResponseDate() {
        return this.responseDate;
    }

    public String getVerb() {
        return this.verb;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultSetIterator
    implements Iterator<Record> {
        private ResultSetIterator() {
        }

        @Override
        public void remove() {
            ListRecordsResponseSAXParser.this.q.poll();
        }

        @Override
        public Record next() {
            if (this.hasNext()) {
                return ListRecordsResponseSAXParser.this.q.poll();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return !(ListRecordsResponseSAXParser.this.q.peek() instanceof IteratorTerminator) && ListRecordsResponseSAXParser.this.q.size() != 0;
        }
    }

    private class IteratorTerminator
    extends Record {
        public IteratorTerminator() {
            super("", new byte[1], -1L, Record.State.STANDARD, "");
        }
    }
}

