#!/bin/bash

#
# TEMPLATE FOR RUNNING JARS FROM BASH SCRIPTS
#
# Directory Structure:
# The following directory structure will be assumed
#
#    app_root/
#      bin/           # All executable scripts go here, ie derivatives of this template
#      lib/           # All 3rd party libs/jar
#      config/        # Any properties or other config files
#      MAINJAR        # jar file containing the main class 
#
# Classpath Construction:
#  - Any .jar in lib/ will be added to the classpath
#  - config/ will be added to the classpath
#
#
# Config Options:
#    MAINJAR        # The jar containing the main classpath
#    PRINT_CONFIG   # Optional. Print config to stderr. Set to empty to not print config.
#    JAVA_HOME      # Optional. If there's a global JAVA_HOME it will be used.  
#

#
# EDIT HERE
#

MAINJAR=summaStorage-0.1.jar
MAINCLASS=dk.statsbiblioteket.doms.summa.SummaStorageDriver
PRINT_CONFIG=true
#JAVA_HOME=/usr/lib/jvm/java


#
# DON'T EDIT BEYOND THIS POINT
#

DEPLOY=`dirname $0`/..
pushd $DEPLOY > /dev/null

# Helper function to set properties in a properties file
# $1 : property name
# $2 : property value
# $3 : property file
function set_property () {
    if [ -z "$1" ]; then
        echo "ERROR: set_property : no property name given" 1>&2
        exit 1
    fi;
    if [ -z "$2" ]; then
        echo "ERROR: set_property : no property value given" 1>&2
        exit 1
    fi;
    if [ -f "$1" ]; then
        echo "ERROR: set_property : property file: is not a regular file" 1>&2
        exit 1
    fi;
    
    echo "Setting property $1=$2 in $3"
    sed -i -e "s@\(<entry key=\"$1\">\)\(.*\)\(</entry>\)@\1$2\3@g" $3
    
    if [ "$?" != "0" ]; then
        echo "Unable to set property. Bailing out." 1>&2
        exit 1
    fi;   
}

# Build classpath
for lib in `ls lib/*.jar`
do
    if [ -z "$CLASSPATH" ]; then
        CLASSPATH=.:$lib
    else
        CLASSPATH=$CLASSPATH:$lib
    fi
done
CLASSPATH=$CLASSPATH:config/:$MAINJAR

# Check JAVA_HOME
DEFAULT_JAVA_HOME=/usr/lib/jvm/java
if [ "$JAVA_HOME" == "" ]; then
    JAVA_HOME=$DEFAULT_JAVA_HOME
    echo "No JAVA_HOME set. Using default JAVA_HOME=$JAVA_HOME" 1>&2
fi;
if [ ! -x "$JAVA_HOME/bin/java" ]; then
    echo "$JAVA_HOME/bin/java does not exist or is not an executable file." 1>&2
    exit 1
fi

# Report settings
if [ ! -z "$PRINT_CONFIG" ]; then 
    echo -e "JavaHome:\t$JAVA_HOME" 1>&2
    echo -e "Classpath:\t$CLASSPATH" 1>&2
    echo -e "MainJar:\t$MAINJAR" 1>&2
    echo -e "AppRoot:\t`pwd`\n" 1>&2
fi


COMMAND="$JAVA_HOME/bin/java -cp $CLASSPATH $MAINCLASS $*"
echo $COMMAND
$COMMAND

popd > /dev/null