/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.sbandex.storage.io;

import dk.statsbiblioteket.sbandex.storage.io.Access;
import dk.statsbiblioteket.sbandex.storage.io.Record;
import dk.statsbiblioteket.sbandex.storage.io.RecordAndNext;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RecordIterator
implements Iterator,
Serializable {
    private final Access iteratorHolder;
    private final Long key;
    private boolean next;

    public RecordIterator(Access access, Long l, boolean bl) {
        this.iteratorHolder = access;
        this.key = l;
        this.next = bl;
    }

    public boolean hasNext() {
        return this.next;
    }

    public Record next() {
        try {
            RecordAndNext recordAndNext = this.iteratorHolder.next(this.key);
            if (recordAndNext == null) {
                throw new NoSuchElementException("access problem");
            }
            this.next = recordAndNext.getNext();
            Record record = recordAndNext.getRecord();
            if (record != null) {
                return record;
            }
            throw new NoSuchElementException("no more elements");
        }
        catch (RemoteException remoteException) {
            throw new NoSuchElementException("access problem:" + remoteException.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

