/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.doms.summa;

import dk.statsbiblioteket.doms.summa.SummaStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SummaStorageDriver {
    private static final Log log = LogFactory.getLog(SummaStorageDriver.class);
    private static final String PROPERTIES_FILE_NAME = "SummaStorage.properties.xml";
    public static String METADATA_PREFIX = "oai_dc";
    public static String SERVICE_NAME = "SummaDOMSStorage";
    public static String OAI_PROVIDER = "http://alhena:7900/oaiprovider";
    public static int REGISTRY_PORT = 7999;
    public static int RMI_PORT = 7990;
    public static String ALL_RECORDS_IDENTIFIER;
    public static String FEDORA_BASE_URL;
    public static String FEDORA_RECORD_DISSEMINATOR;

    public static void main(String[] args) throws IOException {
        System.out.println("Starting SummaStorage");
        try {
            SummaStorageDriver.loadProperties();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw e;
        }
        try {
            SummaStorage storage = new SummaStorage();
            storage.exportRMIInterface();
        }
        catch (Exception e) {
            log.fatal((Object)e);
            System.exit(1);
        }
        System.out.println("Done");
    }

    public static void loadProperties() throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties prop = new Properties();
        InputStream s = loader.getResourceAsStream(PROPERTIES_FILE_NAME);
        if (s != null) {
            prop.loadFromXML(loader.getResourceAsStream(PROPERTIES_FILE_NAME));
        }
        OAI_PROVIDER = prop.getProperty("oaiprovider", "http://localhost:7900/oaiprovider");
        FEDORA_BASE_URL = prop.getProperty("fedora_base_url", "http://localhost:7900/fedora");
        FEDORA_RECORD_DISSEMINATOR = prop.getProperty("fedora_record_disseminator", "DC");
        METADATA_PREFIX = prop.getProperty("meta_data_prefix", "oai_dc");
        SERVICE_NAME = prop.getProperty("service_name", "SummaFedoraStorage");
        ALL_RECORDS_IDENTIFIER = prop.getProperty("all_records_identifier", "SB_DOMS");
        try {
            REGISTRY_PORT = Integer.parseInt(prop.getProperty("registry_port", "7999"));
            RMI_PORT = Integer.parseInt(prop.getProperty("rmi_port", "7990"));
        }
        catch (NumberFormatException e) {
            log.error((Object)"unable to parse port property using defults", (Throwable)e);
            RMI_PORT = 7990;
            REGISTRY_PORT = 7999;
        }
    }

    static {
        FEDORA_BASE_URL = "http://alhena:7900/fedora";
        FEDORA_RECORD_DISSEMINATOR = "DC";
    }
}

