import java.io.Serializable;

/**
 * A webservice for accessing DOMS bitstorage.
 */
public interface Bitstorage extends Serializable {

    /**
     * Upload the provided file to the temporary area of bitstorage,
     * giving it the provided file name.
     * Return the URL to the uploaded file (this includes the file name) and
     * the MD5 checksum of the file.
     * The file is only uploaded to a temporary approve-area of
     * the bitstorage, and needs to be approved by calling approveFile before
     * it is actually moved to the permanent bitstorage.
     *
     * @param file The file to be saved in the bitstorage.
     * @param fileName The name of the file to be saved.
     * @return A BitstorageFileInfo object containing the URL and MD5 checksum
     * of the file uploaded in the bitstorage.
     */
    public abstract BitstorageFileInfo uploadFileAndGetFileInfo(byte[] file,
                                                               String fileName);

    /**
     * Check the earlier uploaded file against the provided checksum, and if
     * this succeeds, and possibly other criteria are met, move the file
     * from the temporary area of bitstorage to the permanent bitstorage.
     *
     * @param fileName File name of the file that needs to be approved.
     * @param MD5Sum The checksum that needs to be checked against the file.
     */
    public abstract void approveFile(String fileName, String MD5Sum);

    /**
     * Delete the named file from bitstorage. Only works for files that have
     * not yet been approved.
     *
     * @param fileName Name of the file in bitstorage that needs to be deleted.
     */
    public abstract void deleteFile(String fileName);

    /**
     * Return the number of bytes left in bitstorage.
     * 
     * @return The number of bytes left in bitstorage.
     */
    public abstract long spaceLeft();

}
