import java.io.Serializable;

/**
 * The return value of the uploadFileAndGetFileInfo method of the
 * Bitstorage API.
 */
public class BitstorageFileInfo implements Serializable {
    private String url;
    private String MD5Sum;

    /**
     * Returns the URL into bitstorage of the file that was uploaded.
     *
     * @return The URL of the uploaded file in the bitstorage.
     */
    public String getUrl() {
        return url;
    }

    /**
     * Set the URL of the file that was uploaded.
     *
     * @param url The URL of the file that was uploaded.
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Returns the MD5 checksum of the file uploaded to the bitstorage.
     *
     * @return The MD5 checksum of the file uploaded to the bitstorage.
     */
    public String getMD5Sum() {
        return MD5Sum;
    }

    /**
     * Set the MD5 checksum of the file uploaded to the bitstorage.
     * 
     * @param MD5Sum The MD5 checksum of the file uploaded to the bitstorage.
     */
    public void setMD5Sum(String MD5Sum) {
        this.MD5Sum = MD5Sum;
    }

}
