/**
 * A webservice for generating a PID (Persistent ID)
 */
public interface PIDGenerator {

    /**
     * Generate the next available PID.
     *
     * @param infix A string, all or part of which may be used as part of the
     * PID, but with no guarantee. May be left empty.
     * @return The next available (unique) PID, possibly including (part of) the
     * requested infix.
     */
    public abstract String generateNextAvailablePID(String infix);
}

