import java.io.Serializable;

/**
 * The return value of the CharacterizeFile method of the
 * FileCharacterizer API.
 */
public class FileCharacterization implements Serializable {
    byte[] characterizationOutput;
    String fileFormatID;

    /**
     * Returns the output of the characterization tool.
     *
     * @return The output of the characterization tool.
     */
    public byte[] getCharacterizationOutput() {
        return characterizationOutput;
    }

    /**
     * Set the output of the characterization tool.
     *
     * @param characterizationOutput The output of the characterization tool.
     */
    public void setCharacterizationOutput(byte[] characterizationOutput) {
        this.characterizationOutput = characterizationOutput;
    }

    /**
     * Returns the PRONOM file format ID.
     *
     * @return The PRONOM file format ID.
     */
    public String getFileFormatID() {
        return fileFormatID;
    }

    /**
     * Set the PRONOM file format ID.
     * 
     * @param fileFormatID The PRONOM file format ID.
     */
    public void setFileFormatID(String fileFormatID) {
        this.fileFormatID = fileFormatID;
    }

}
