/**
 * A webservice for file characterization
 */
public interface FileCharacterizer {

    /**
     * Perform a characterization of the file in bitstorage pointed to by the
     * provided file name. Returns the output from the characterization tool,
     * as well as a PRONOM file format identifier.
     * 
     * @param fileName Name of the file in bitstorage that needs to be
     * characterized.
     * @return An object containing the output of the characterization, as
     * well as a PRONOM file format identifier.
     */
    public abstract FileCharacterization CharacterizeFile(String fileName);
}
