#!/bin/bash

# $Id install.sh $
# Author: jrg
# Date:   2008-08-21
#
# Script for installing the testbed for use by the doms gui.
#
# USAGE: After unpacking, edit conf/config to suit your needs, and run this
# script.


#
# Sets up basic variables
# (SCRIPT_DIR becomes the bin-dir of the minidoms-dir)
#
SCRIPT_DIR=$(dirname $0)
pushd $SCRIPT_DIR > /dev/null
SCRIPT_DIR=$(pwd)
popd > /dev/null

# Import settings
source $SCRIPT_DIR/config/conf



function usage() {
    echo ""
    echo -n "Usage: install.sh  <install-dir>"
    echo ""
    exit 1
}

#
# Parses command line arguments.
# http://www.shelldorado.com/goodcoding/cmdargs.html
#
while getopts dD:f:p: opt
    do
    case "$opt" in
        h) usage;;
        \?) # unknown flag
             echo "Unrecognised option. Bailing out." 1>&2
             usage;;
    esac
done
shift $(expr $OPTIND - 1)

#
# Check for install-folder and potentially create it.
#
TESTBED_DIR=$@
if [ -z "$TESTBED_DIR" ]; then
    echo "install-dir not specified. Bailing out." 1>&2
    usage
fi
if [ -d $TESTBED_DIR ]; then
    echo ""
else
    mkdir $TESTBED_DIR
fi
pushd $@ > /dev/null
TESTBED_DIR=$(pwd)
popd > /dev/null
echo "Full path destination: $TESTBED_DIR"




# Setup a tomcat server (not starting it though)
ps ax | grep org.apache.catalina.startup.Bootstrap | grep -v grep | awk '{print $1}' | xargs kill >/dev/null 2>&1

cp $SCRIPT_DIR/tomcat/apache-tomcat-5.5.26.tar.gz $TESTBED_DIR/

pushd $TESTBED_DIR
tar -zxf apache-tomcat-5.5.26.tar.gz
mv apache-tomcat-5.5.26 tomcat
rm apache-tomcat-5.5.26.tar.gz
popd
#Copy the config scripts
cp $SCRIPT_DIR/tomcat/config/*  $TESTBED_DIR/tomcat/conf
cp $SCRIPT_DIR/tomcat/bin/*  $TESTBED_DIR/tomcat/bin 


# Install fedora including database into the tomcat
cp $SCRIPT_DIR/fedora/fedora.tar.gz $TESTBED_DIR/
pushd $TESTBED_DIR
tar -xzf fedora.tar.gz
rm fedora.tar.gz
cp $SCRIPT_DIR/fedora/fedora.war tomcat/webapps/
cp $SCRIPT_DIR/fedora/fedora.fcfg $TESTBED_DIR/fedora/server/config
popd


# Install into tomcat: webservices
cp $SCRIPT_DIR/webservices/*.war $TESTBED_DIR/tomcat/webapps

# Start the tomcat server
$TESTBED_DIR/tomcat/bin/startup.sh

sleep 15

export FEDORA_HOME=$TESTBED_DIR/fedora

sh $TESTBED_DIR/fedora/client/bin/fedora-ingest.sh dir $SCRIPT_DIR/baseobjects 'info:fedora/fedora-system:FOXML-1.1' localhost:8080 fedoraAdmin fedoraAdminPass http

sh $TESTBED_DIR/fedora/client/bin/fedora-ingest.sh dir $SCRIPT_DIR/tapeobjects 'info:fedora/fedora-system:FOXML-1.1' localhost:8080 fedoraAdmin fedoraAdminPass http

sh $TESTBED_DIR/fedora/client/bin/fedora-ingest.sh dir $SCRIPT_DIR/newspaperobjects 'info:fedora/fedora-system:FOXML-1.1' localhost:8080 fedoraAdmin fedoraAdminPass http

sh $TESTBED_DIR/fedora/client/bin/fedora-ingest.sh dir $SCRIPT_DIR/radioobjects 'info:fedora/fedora-system:FOXML-1.1' localhost:8080 fedoraAdmin fedoraAdminPass http

sh $TESTBED_DIR/fedora/client/bin/fedora-ingest.sh dir $SCRIPT_DIR/yearbookobjects 'info:fedora/fedora-system:FOXML-1.1' localhost:8080 fedoraAdmin fedoraAdminPass http

$TESTBED_DIR/tomcat/bin/shutdown.sh



