/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.chaos.metadata.migrate;

import dk.statsbiblioteket.chaos.metadata.migrate.exception.MigrationInitializationException;
import dk.statsbiblioteket.chaos.metadata.migrate.export.DOMSMetadataXMLFileOutputService;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.DOMSMetadataExtractor;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataExtractionConnectToDOMSException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.RadioProgram;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.RadioProgramSearchResultItem;
import dk.statsbiblioteket.chaos.metadata.migrate.filter.FilterService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMSMetadataMigrationService {
    private static Logger logger = Logger.getLogger(DOMSMetadataMigrationService.class);
    private DOMSMetadataExtractor domsMetadataExtractor;
    private String exportLogFile;
    private int pageSize;

    public DOMSMetadataMigrationService(Properties properties) throws MigrationInitializationException {
        this.domsMetadataExtractor = new DOMSMetadataExtractor(properties);
    }

    public DOMSMetadataMigrationService(String propertyFilename) throws MigrationInitializationException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertyFilename));
        }
        catch (IOException e) {
            throw new MigrationInitializationException("Unable to load configuraiton file.", e);
        }
        String log4jConfigurationFilename = properties.getProperty("log4jPropertyFile");
        System.err.println("Looking for log4j configuraiton in file:\n" + new File(log4jConfigurationFilename).getAbsolutePath());
        DOMConfigurator.configure(log4jConfigurationFilename);
        this.domsMetadataExtractor = new DOMSMetadataExtractor(properties);
        this.exportLogFile = properties.getProperty("exportLogFile", "export.log");
        this.pageSize = Integer.parseInt(properties.getProperty("extractionPageSize", "1000"));
    }

    public void migrateMetadataToMCM(Date updateProgramsSince) {
        try {
            List<RadioProgramSearchResultItem> searchResultItems = this.domsMetadataExtractor.fetchRadioProgramMetadataUpdatedSince(updateProgramsSince);
        }
        catch (DOMSMetadataExtractionConnectToDOMSException e) {
            logger.error("Unable to connect to DOMS.");
            throw new RuntimeException("Unable to connect to DOMS. Aborting.", e);
        }
    }

    public void extractAndExportMetadata(List<String> shardPids, List<String> sourceFilesToFilterOut) throws DOMSMetadataExtractionConnectToDOMSException {
        block13: {
            BufferedWriter out = null;
            try {
                File logFile = new File(this.exportLogFile);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF8"));
                int okRadioPrograms = 0;
                int failedRadioPrograms = 0;
                int offset = 0;
                int page = 0;
                while (offset < shardPids.size()) {
                    int toIndex = Math.min(shardPids.size(), offset + this.pageSize);
                    List<String> pageShardPids = shardPids.subList(offset, toIndex);
                    logger.info("Extracting PID's from DOMS - [" + offset + ";" + toIndex + "]");
                    List<RadioProgramSearchResultItem> radioProgramSearchResult = this.domsMetadataExtractor.fetchRadioProgramMetadataFromShardPids(pageShardPids, true);
                    logger.info("Filtering out programs based on source files in clips.");
                    FilterService.filterResult(sourceFilesToFilterOut, radioProgramSearchResult);
                    logger.info("Exporting radio programs to XML files.");
                    for (RadioProgramSearchResultItem radioProgramSearchResultItem : radioProgramSearchResult) {
                        RadioProgram radioProgram;
                        if (radioProgramSearchResultItem.isReadyForExport()) {
                            radioProgram = radioProgramSearchResultItem.getRadioProgram();
                            out.write("Exporting radioprogram: " + radioProgram + "\n");
                            DOMSMetadataXMLFileOutputService.writeRadioProgramMetadataToXMLFile("data", radioProgram);
                            ++okRadioPrograms;
                            continue;
                        }
                        radioProgram = radioProgramSearchResultItem.getRadioProgram();
                        out.write("Not exporting radioprogram: " + radioProgram + "\n");
                        out.write("Reason(s): " + radioProgramSearchResultItem.getReasonForNotReadyForExport() + "\n");
                        ++failedRadioPrograms;
                    }
                    out.write("Page " + page + ": Successfully exported number of programs : " + okRadioPrograms + "\n");
                    out.write("Page " + page + ": Failed to export number of programs      : " + failedRadioPrograms + "\n");
                    offset = ++page * this.pageSize;
                }
                out.write("Finished export. Tatal pages " + page + " of size " + this.pageSize + "\n");
                out.write("Successfully exported number of programs : " + okRadioPrograms + "\n");
                out.write("Failed to export number of programs      : " + failedRadioPrograms + "\n");
                out.close();
                logger.info("Export to XML files done.");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unable to create log file.", e);
                if (out == null) break block13;
                try {
                    out.close();
                }
                catch (IOException e1) {
                    logger.error("Unable to close writer: " + out);
                    throw new RuntimeException("Unable to close writer", e1);
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Unable to create log file.", e);
                if (out == null) break block13;
                try {
                    out.close();
                }
                catch (IOException e1) {
                    logger.error("Unable to close writer: " + out);
                    throw new RuntimeException("Unable to close writer", e1);
                }
            }
            catch (IOException e) {
                logger.error("Unable to create log file. Stop execution.", e);
                if (out == null) break block13;
                try {
                    out.close();
                }
                catch (IOException e1) {
                    logger.error("Unable to close writer: " + out);
                    throw new RuntimeException("Unable to close writer", e1);
                }
            }
        }
    }

    private List<String> extractChannelList(String channelListString) {
        String[] channelArray = channelListString.split(";");
        ArrayList<String> channelList = new ArrayList<String>();
        for (String channelID : channelArray) {
            channelList.add(channelID);
            logger.trace("Channel extracted from property: " + channelID);
        }
        return channelList;
    }
}

