/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.chaos.metadata.migrate.extraction;

import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataExtractionConnectToDOMSException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataExtractionException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataExtractionParseException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataExtractionParseFilenameException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataExtractionParsePBCoreException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataExtractionUnknownMediaTypeException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.MediaClipWav;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.MediaTypeEnum;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.PBCoreProgramMetadata;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.RadioProgram;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.RadioProgramSearchResultItem;
import dk.statsbiblioteket.chaos.metadata.migrate.model.BESClippingConfiguration;
import dk.statsbiblioteket.doms.central.CentralWebservice;
import dk.statsbiblioteket.doms.central.CentralWebserviceService;
import dk.statsbiblioteket.doms.central.InvalidCredentialsException;
import dk.statsbiblioteket.doms.central.InvalidResourceException;
import dk.statsbiblioteket.doms.central.MethodFailedException;
import dk.statsbiblioteket.doms.central.RecordDescription;
import dk.statsbiblioteket.doms.central.Relation;
import dk.statsbiblioteket.doms.central.SearchResult;
import dk.statsbiblioteket.util.xml.DOM;
import dk.statsbiblioteket.util.xml.XPathSelector;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMSMetadataExtractor {
    static Logger logger = Logger.getLogger(DOMSMetadataExtractor.class);
    private static final QName CENTRAL_WEBSERVICE_SERVICE = new QName("http://central.doms.statsbiblioteket.dk/", "CentralWebserviceService");
    private CentralWebservice domsService;
    private BESClippingConfiguration besConfiguration;

    public DOMSMetadataExtractor(Properties properties) {
        String domsWSAPIEndpointUrlString = properties.getProperty("domsWSAPIEndpointUrlString");
        String userName = properties.getProperty("userName");
        String password = properties.getProperty("password");
        this.domsService = this.createDOMSCentralWebService(domsWSAPIEndpointUrlString, userName, password);
        Long radioStartOffset = Long.valueOf(properties.getProperty("besConfiguredRadioStartOffset"));
        Long radioEndOffset = Long.valueOf(properties.getProperty("besConfiguredRadioEndOffset"));
        this.besConfiguration = new BESClippingConfiguration(radioStartOffset, radioEndOffset);
    }

    public DOMSMetadataExtractor(String domsWSAPIEndpointUrlString, String userName, String password, long besConfiguredRadioStartOffset, long besConfiguredRadioEndOffset) {
        this.domsService = this.createDOMSCentralWebService(domsWSAPIEndpointUrlString, userName, password);
        this.besConfiguration = new BESClippingConfiguration(besConfiguredRadioStartOffset, besConfiguredRadioEndOffset);
    }

    @Deprecated
    public List<String> fetchAllRadioShardPids() throws InvalidCredentialsException, MethodFailedException, InvalidResourceException {
        ArrayList<String> shardPids = new ArrayList<String>();
        List<SearchResult> waveFileObjects = this.domsService.findObjects("*.wav", 0, 1);
        for (SearchResult searchResult : waveFileObjects) {
            logger.debug("Found wave file with pid: " + searchResult.getPid());
            List<Relation> relationsToFile = this.domsService.getInverseRelations(searchResult.getPid());
            for (Relation fileRelation : relationsToFile) {
                String shardPid = fileRelation.getSubject();
                shardPids.add(shardPid);
            }
        }
        return shardPids;
    }

    public List<RadioProgramSearchResultItem> fetchRadioProgramMetadataUpdatedSince(Date updatedSince) throws DOMSMetadataExtractionConnectToDOMSException {
        List<RecordDescription> updatedShardPids = this.fetchUpdatedShardPids(updatedSince);
        List<RadioProgramSearchResultItem> radioProgramMetadataList = this.fetchRadioProgramMetadataFromShardPids(updatedShardPids);
        return radioProgramMetadataList;
    }

    protected List<RecordDescription> fetchUpdatedShardPids(Date updatedSince) throws DOMSMetadataExtractionConnectToDOMSException {
        ArrayList<RecordDescription> updatedShardPids = new ArrayList<RecordDescription>();
        int pageOffset = 0;
        int pageSize = 10000;
        boolean continueToNextPage = true;
        while (continueToNextPage) {
            List<RecordDescription> newPidsInPage = this.fetchUpdatedShardPidsPaged(updatedSince, pageOffset * pageSize, pageSize);
            updatedShardPids.addAll(newPidsInPage);
            ++pageOffset;
            continueToNextPage = !newPidsInPage.isEmpty();
        }
        return updatedShardPids;
    }

    protected List<RecordDescription> fetchUpdatedShardPids(Date updatedSince, int maxNumberToReturn) throws DOMSMetadataExtractionConnectToDOMSException {
        ArrayList<RecordDescription> updatedShardPids = new ArrayList<RecordDescription>();
        int pageOffset = 0;
        int pageSize = 10000;
        boolean continueToNextPage = true;
        while (continueToNextPage) {
            int remaningPageSize = Math.min(pageSize, pageOffset * pageSize - maxNumberToReturn);
            int offset = pageOffset * pageSize;
            List<RecordDescription> newPidsInPage = this.fetchUpdatedShardPidsPaged(updatedSince, offset, remaningPageSize);
            updatedShardPids.addAll(newPidsInPage);
            continueToNextPage = !newPidsInPage.isEmpty() || maxNumberToReturn < ++pageOffset * pageSize;
        }
        return updatedShardPids;
    }

    protected List<RecordDescription> fetchUpdatedShardPidsPaged(Date updatedSince, int offset, int pageSize) throws DOMSMetadataExtractionConnectToDOMSException {
        ArrayList<RecordDescription> newShardPidsInPage = new ArrayList<RecordDescription>();
        try {
            List<RecordDescription> domsRecords = this.domsService.getIDsModified(updatedSince.getTime(), "doms:RadioTV_Collection", "BES", "Published", offset, pageSize);
            logger.info("Page " + offset + " containing " + domsRecords.size() + " records");
            for (RecordDescription record : domsRecords) {
                String recordS = "Found updated pid = '" + record.getPid() + "' Entry CM = '" + record.getEntryContentModelPid() + "' Date = " + new Date(record.getDate());
                if ("doms:ContentModel_Shard".equals(record.getEntryContentModelPid())) {
                    newShardPidsInPage.add(record);
                    continue;
                }
                logger.warn("Record with unexpted contentModel: " + recordS);
            }
        }
        catch (InvalidCredentialsException e) {
            throw new DOMSMetadataExtractionConnectToDOMSException("Failed to connect to DOMS.", e);
        }
        catch (MethodFailedException e) {
            throw new DOMSMetadataExtractionConnectToDOMSException("Failed to connect to DOMS.", e);
        }
        return newShardPidsInPage;
    }

    public List<String> fetchUpdatedShardPidsPagedAsString(Date updatedSince, int offset, int pageSize) throws DOMSMetadataExtractionConnectToDOMSException {
        ArrayList<String> shardPids = new ArrayList<String>();
        List<RecordDescription> searchResult = this.fetchUpdatedShardPidsPaged(updatedSince, offset, pageSize);
        for (RecordDescription recordDescription : searchResult) {
            shardPids.add(recordDescription.getPid());
        }
        return shardPids;
    }

    public List<RadioProgramSearchResultItem> fetchRadioProgramMetadataFromShardPids(List<RecordDescription> recordDescription) throws DOMSMetadataExtractionConnectToDOMSException {
        ArrayList<RadioProgramSearchResultItem> searchResults = new ArrayList<RadioProgramSearchResultItem>();
        int i = 0;
        for (RecordDescription searchResultRecord : recordDescription) {
            RadioProgramSearchResultItem radioProgramSearchResult = null;
            try {
                logger.info("Handling shard: " + searchResultRecord + " - " + i + "/ " + recordDescription.size());
                RadioProgram radioProgram = new RadioProgram(searchResultRecord.getPid(), searchResultRecord.getDate(), this.besConfiguration);
                radioProgramSearchResult = this.fetchRadioProgramMetadataFromShardPid(radioProgram);
            }
            catch (DOMSMetadataExtractionException e) {
                logger.warn("Unable to extract radio program: " + e.getMessage(), e);
                RadioProgram radioProgram = new RadioProgram(searchResultRecord.getPid(), searchResultRecord.getDate());
                radioProgramSearchResult = new RadioProgramSearchResultItem(radioProgram);
                radioProgramSearchResult.extractionFailed("Unable to extract metadata.");
            }
            searchResults.add(radioProgramSearchResult);
            ++i;
        }
        return searchResults;
    }

    public List<RadioProgramSearchResultItem> fetchRadioProgramMetadataFromShardPids(List<String> shardPids, boolean useThisMethod) throws DOMSMetadataExtractionConnectToDOMSException {
        ArrayList<RadioProgramSearchResultItem> searchResults = new ArrayList<RadioProgramSearchResultItem>();
        int i = 0;
        for (String shardPid : shardPids) {
            RadioProgramSearchResultItem radioProgramSearchResult = null;
            try {
                logger.info("Handling shard: " + shardPid + " - " + i + "/ " + shardPids.size());
                RadioProgram radioProgram = new RadioProgram(shardPid, this.besConfiguration);
                radioProgramSearchResult = this.fetchRadioProgramMetadataFromShardPid(radioProgram);
            }
            catch (DOMSMetadataExtractionException e) {
                logger.warn("Unable to extract radio program: " + e.getMessage(), e);
                RadioProgram radioProgram = new RadioProgram(shardPid);
                radioProgramSearchResult = new RadioProgramSearchResultItem(radioProgram);
                radioProgramSearchResult.extractionFailed("Unable to extract metadata.");
            }
            searchResults.add(radioProgramSearchResult);
            ++i;
        }
        return searchResults;
    }

    protected RadioProgramSearchResultItem fetchRadioProgramMetadataFromShardPid(RadioProgram radioProgram) throws DOMSMetadataExtractionConnectToDOMSException, DOMSMetadataExtractionException {
        try {
            RadioProgramSearchResultItem searchResult = new RadioProgramSearchResultItem(radioProgram);
            String shardMetadata = this.domsService.getDatastreamContents(radioProgram.shardPid, "SHARD_METADATA");
            logger.trace(" - related shard metadata:\n " + shardMetadata);
            try {
                List<MediaClipWav> radioClips = this.extractRadioClipMetadata(shardMetadata);
                for (MediaClipWav soundClip : radioClips) {
                    radioProgram.addRadioClip(soundClip);
                }
            }
            catch (DOMSMetadataExtractionException e) {
                logger.warn("Could not extract shard data.", e);
                searchResult.extractionFailed(radioProgram.shardPid + " - Could not extract shard data. Reason: " + e.getMessage());
            }
            List<Relation> relationsToShard = this.domsService.getInverseRelations(radioProgram.shardPid);
            if (relationsToShard.size() != 1) {
                throw new DOMSMetadataExtractionException("Unexpected number of relations to the shard with pid: " + radioProgram.shardPid);
            }
            Relation shardRelation = relationsToShard.get(0);
            String programPid = shardRelation.getSubject();
            logger.trace("   - related program: " + programPid);
            String programPBCore = this.domsService.getDatastreamContents(programPid, "PBCORE");
            logger.trace(programPBCore);
            try {
                PBCoreProgramMetadata pbcoreProgramMetadata = this.extractMetadataFromPBCore(radioProgram.shardPid, programPBCore);
                radioProgram.setPbcoreProgramMetadata(pbcoreProgramMetadata);
                logger.debug("Found program: " + pbcoreProgramMetadata.titel);
            }
            catch (DOMSMetadataExtractionParsePBCoreException e) {
                logger.warn(radioProgram.shardPid + " - Could not extract metadata from PBCore", e);
                searchResult.extractionFailed("Could not extract metadata from PBCore");
            }
            if (!searchResult.validate()) {
                logger.warn(radioProgram.shardPid + " - Could not validate search result.");
            }
            return searchResult;
        }
        catch (InvalidCredentialsException e) {
            logger.error("Invalid configuration. Stopping extraction.", e);
            throw new DOMSMetadataExtractionConnectToDOMSException("Invalid configuration. Stopping extraction.", e);
        }
        catch (InvalidResourceException e) {
            logger.error("Invalid configuration. Stopping extraction.", e);
            throw new DOMSMetadataExtractionConnectToDOMSException("Invalid configuration. Stopping extraction.", e);
        }
        catch (MethodFailedException e) {
            logger.error("Invalid configuration. Stopping extraction.", e);
            throw new DOMSMetadataExtractionConnectToDOMSException("Invalid configuration. Stopping extraction.", e);
        }
    }

    protected PBCoreProgramMetadata extractMetadataFromPBCore(String shardPid, String programPBCore) throws DOMSMetadataExtractionParsePBCoreException {
        XPathSelector xpath = DOM.createXPathSelector("pb", "http://www.pbcore.org/PBCore/PBCoreNamespace.html");
        Document doc = DOM.stringToDOM(programPBCore, true);
        String channel = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcorePublisher[pb:publisherRole='channel_name']/pb:publisher");
        logger.debug("Parsed channel: " + channel);
        String titleTitel = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreTitle[pb:titleType='titel']/pb:title");
        logger.debug("Parsed titleTitel: " + titleTitel);
        String titleOriginaltitel = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreTitle[pb:titleType='originaltitel']/pb:title");
        logger.debug("Parsed titleOriginaltitel: " + titleOriginaltitel);
        String titleEpisodetitel = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreTitle[pb:titleType='episodetitel']/pb:title");
        logger.debug("Parsed titleEpisodetitel: " + titleEpisodetitel);
        Date dateAvailableStart = DOMSMetadataExtractor.getStartDateFromPBCore(programPBCore);
        Date dateAvailableEnd = DOMSMetadataExtractor.getEndDateFromPBCore(programPBCore);
        String descriptionKortOmtale = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreDescription[pb:descriptionType='kortomtale']/pb:description");
        logger.debug("Parsed descriptionKortOmtale: " + descriptionKortOmtale);
        String descriptionLangOmtale1 = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreDescription[pb:descriptionType='langomtale1']/pb:description");
        logger.debug("Parsed descriptionLangOmtale1: " + descriptionLangOmtale1);
        String descriptionLangOmtale2 = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreDescription[pb:descriptionType='langomtale2']/pb:description");
        logger.debug("Parsed descriptionLangOmtale2: " + descriptionLangOmtale2);
        String creatorForfattere = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreCreator[pb:creatorRole='forfatter']/pb:creator");
        logger.debug("Parsed creatorForfattere: " + creatorForfattere);
        String contributerMedvirkende = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreContributor[pb:contributorRole='medvirkende']/pb:contributor");
        logger.debug("Parsed contributerMedvirkende: " + contributerMedvirkende);
        String contributerInstruktion = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreContributor[pb:contributorRole='instruktion']/pb:contributor");
        logger.debug("Parsed contributerInstruktion: " + contributerInstruktion);
        PBCoreProgramMetadata pbcoreProgramMetadata = new PBCoreProgramMetadata(channel, titleTitel, titleOriginaltitel, titleEpisodetitel, dateAvailableStart, dateAvailableEnd, descriptionKortOmtale, descriptionLangOmtale1, descriptionLangOmtale2, creatorForfattere, contributerMedvirkende, contributerInstruktion);
        return pbcoreProgramMetadata;
    }

    protected List<MediaClipWav> extractRadioClipMetadata(String shardMetadata) throws DOMSMetadataExtractionException {
        Document doc = DOM.stringToDOM(shardMetadata, true);
        XPathSelector xpath = DOM.createXPathSelector(new String[0]);
        NodeList fileNodes = xpath.selectNodeList(doc, "//file");
        int numberOfFileNode = fileNodes.getLength();
        logger.trace("Number of file nodes: " + numberOfFileNode);
        ArrayList<MediaClipWav> radioClips = new ArrayList<MediaClipWav>();
        for (int i = 0; i < numberOfFileNode; ++i) {
            Node filenode = fileNodes.item(i);
            String filename = xpath.selectString(filenode, "file_name");
            String clipStartOffsetString = xpath.selectString(filenode, "program_start_offset");
            String clipLengthString = xpath.selectString(filenode, "program_clip_length");
            long clipStartOffset = Long.parseLong(clipStartOffsetString);
            long clipLength = Long.parseLong(clipLengthString);
            logger.trace(i + " Filename node value     : " + filename);
            logger.trace(i + " Start offset node value : " + clipStartOffset);
            logger.trace(i + " Clip length node value  : " + clipLength);
            MediaTypeEnum fileMedia = this.extractMediaTypeFromFilename(filename);
            if (!fileMedia.equals((Object)MediaTypeEnum.WAV)) {
                throw new DOMSMetadataExtractionException("Invalid media type. Expecting " + (Object)((Object)MediaTypeEnum.WAV) + ". Was: " + (Object)((Object)fileMedia));
            }
            Date clipStartDate = this.extractClipStartDateFromWavFilename(filename, clipStartOffset);
            radioClips.add(new MediaClipWav(filename, clipStartDate, clipLength));
        }
        return radioClips;
    }

    protected Date extractClipStartDateFromWavFilename(String filename, long offset) throws DOMSMetadataExtractionParseFilenameException, DOMSMetadataExtractionParseException {
        Date sourceStart;
        Pattern p = Pattern.compile(".*_([0-9]{14})_[0-9]{14}_encoder[0-9]-[0-9]\\.wav", 32);
        Matcher m = p.matcher(filename);
        if (!m.find()) {
            throw new DOMSMetadataExtractionParseFilenameException("Could not parse filename: " + filename);
        }
        String sourceStartString = m.group(1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            sourceStart = sdf.parse(sourceStartString);
        }
        catch (ParseException e) {
            logger.warn("Could not parse date from string: " + sourceStartString + " from filename: " + filename);
            throw new DOMSMetadataExtractionParseException("Could not parse date from string: " + sourceStartString);
        }
        Date clipStartDate = new Date(sourceStart.getTime() + offset * 1000L);
        return clipStartDate;
    }

    protected MediaTypeEnum extractMediaTypeFromFilename(String filename) throws DOMSMetadataExtractionUnknownMediaTypeException, DOMSMetadataExtractionParseFilenameException {
        Pattern p = Pattern.compile(".*\\.(.*)", 32);
        Matcher m = p.matcher(filename);
        if (!m.find()) {
            throw new DOMSMetadataExtractionParseFilenameException("Could not parse filename: " + filename);
        }
        String filenameExtension = m.group(1);
        MediaTypeEnum type = null;
        if ("wav".equals(filenameExtension)) {
            type = MediaTypeEnum.WAV;
        } else if ("mp3".equals(filenameExtension)) {
            type = MediaTypeEnum.MP3;
        } else if ("jpg".equals(filenameExtension)) {
            type = MediaTypeEnum.JPG;
        } else if ("mpeg".equals(filenameExtension)) {
            type = MediaTypeEnum.MPEG;
        } else if ("ts".equals(filenameExtension)) {
            type = MediaTypeEnum.TS;
        } else if ("flv".equals(filenameExtension)) {
            type = MediaTypeEnum.FLV;
        } else {
            throw new DOMSMetadataExtractionUnknownMediaTypeException("Unknown media type of file: " + filename + ". " + "Infered extension was: " + filenameExtension);
        }
        return type;
    }

    protected static String getChannelId(String programPBCore) {
        XPathSelector xpath = DOM.createXPathSelector("pb", "http://www.pbcore.org/PBCore/PBCoreNamespace.html");
        Document doc = DOM.stringToDOM(programPBCore, true);
        String channelID = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcorePublisher[pb:publisherRole='channel_name']/pb:publisher");
        logger.debug("Parsed channelID: " + channelID);
        return channelID;
    }

    private static Date getStartDateFromPBCore(String programPBCore) throws DOMSMetadataExtractionParsePBCoreException {
        Date date;
        XPathSelector xpath = DOM.createXPathSelector("pb", "http://www.pbcore.org/PBCore/PBCoreNamespace.html");
        Document doc = DOM.stringToDOM(programPBCore, true);
        String startDateString = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreInstantiation/pb:pbcoreDateAvailable/pb:dateAvailableStart");
        logger.debug("Parsed startDate: " + startDateString);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ");
        try {
            date = formatter.parse(startDateString);
        }
        catch (ParseException e) {
            logger.warn("Unable to parse start date '" + startDateString + "' from PBCore.\n" + programPBCore);
            throw new DOMSMetadataExtractionParsePBCoreException("Unable to parse start date " + startDateString + " from PBCore.", e);
        }
        return date;
    }

    private static Date getEndDateFromPBCore(String programPBCore) throws DOMSMetadataExtractionParsePBCoreException {
        Date date;
        XPathSelector xpath = DOM.createXPathSelector("pb", "http://www.pbcore.org/PBCore/PBCoreNamespace.html");
        Document doc = DOM.stringToDOM(programPBCore, true);
        String endDateString = xpath.selectString(doc, "/pb:PBCoreDescriptionDocument/pb:pbcoreInstantiation/pb:pbcoreDateAvailable/pb:dateAvailableEnd");
        logger.debug("Parsed endDate: " + endDateString);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ");
        try {
            date = formatter.parse(endDateString);
        }
        catch (ParseException e) {
            logger.warn("Unable to parse end date " + endDateString + " from PBCore.\n" + programPBCore);
            throw new DOMSMetadataExtractionParsePBCoreException("Unable to parse end date " + endDateString + " from PBCore.", e);
        }
        return date;
    }

    private CentralWebservice createDOMSCentralWebService(String domsWSAPIEndpointUrlString, String userName, String password) {
        URL domsWSAPIEndpoint;
        logger.debug("Creating DOMS Client");
        logger.debug("domsWSAPIEndpointUrlString, " + domsWSAPIEndpointUrlString);
        logger.debug("userName: " + userName);
        logger.debug("password: " + password);
        try {
            domsWSAPIEndpoint = new URL(domsWSAPIEndpointUrlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("URL to DOMS not configured correctly. Was: " + domsWSAPIEndpointUrlString, e);
        }
        CentralWebservice domsAPI = new CentralWebserviceService(domsWSAPIEndpoint, CENTRAL_WEBSERVICE_SERVICE).getCentralWebservicePort();
        Map domsAPILogin = ((BindingProvider)domsAPI).getRequestContext();
        domsAPILogin.put("javax.xml.ws.security.auth.username", userName);
        domsAPILogin.put("javax.xml.ws.security.auth.password", password);
        return domsAPI;
    }
}

