/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DocumentUtils {
    public static final DocumentBuilder DOCUMENT_BUILDER;
    public static final Transformer DOCUMENT_TRANSFORMER;

    public static String documentToString(Document doc) throws TransformerException {
        StringWriter writer = new StringWriter();
        DOCUMENT_TRANSFORMER.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    public static Document stringToDocument(String doc) throws SAXException {
        ByteArrayInputStream in = new ByteArrayInputStream(doc.getBytes());
        try {
            return DOCUMENT_BUILDER.parse(in);
        }
        catch (IOException e) {
            throw new Error("Problem reading a string, should never happen", e);
        }
    }

    static {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DOCUMENT_BUILDER = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new Error("Error initialising default document builder", e);
        }
        try {
            DOCUMENT_TRANSFORMER = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new Error("Error initialising default document transformer", e);
        }
    }
}

