/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.StringWriter;
import java.util.Calendar;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class Profiler {
    private long startTime = 0L;
    private long beats = 0L;
    private long expectedTotal = 0L;
    private int bpsSpan = 10;
    private long[] queue = new long[10];
    private int queueStart = -1;
    private int queueEnd = -1;
    private boolean paused = false;
    private long pauseTime = 0L;

    public Profiler() {
        this.reset();
    }

    public Profiler(int expectedTotal) {
        this.reset();
        this.setExpectedTotal(expectedTotal);
    }

    public Profiler(int expectedTotal, int bpsSpan) {
        this.reset();
        this.setExpectedTotal(expectedTotal);
        this.setBpsSpan(bpsSpan);
    }

    public long getBeats() {
        return this.beats;
    }

    public synchronized void setBeats(long value) {
        this.beats = Math.max(0L, value);
    }

    public long getExpectedTotal() {
        return this.expectedTotal;
    }

    public synchronized void setExpectedTotal(long value) {
        this.expectedTotal = Math.max(0L, value);
    }

    public int getBpsSpan() {
        return this.bpsSpan;
    }

    public synchronized void setBpsSpan(int value) {
        this.bpsSpan = Math.max(0, value);
        if (this.bpsSpan == 1) {
            this.bpsSpan = 2;
        }
        this.queue = new long[this.bpsSpan];
        this.queueStart = -1;
        this.queueEnd = -1;
        this.paused = false;
    }

    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.beats = 0L;
        this.queueStart = -1;
        this.queueEnd = -1;
        this.paused = false;
    }

    public long beat() {
        return this.beat(1L);
    }

    private synchronized long beat(long increase) {
        this.unpause();
        this.beats += increase;
        if (this.bpsSpan > 0) {
            ++this.queueEnd;
            this.queueEnd %= this.bpsSpan;
            if (this.queueEnd == this.queueStart) {
                ++this.queueStart;
                this.queueStart %= this.bpsSpan;
            }
            if (this.queueStart == -1) {
                this.queueStart = 0;
            }
            this.queue[this.queueEnd] = System.currentTimeMillis();
        }
        return this.beats;
    }

    public int queueSize() {
        if (this.queueStart == -1) {
            return 0;
        }
        if (this.queueStart == this.queueEnd) {
            return 1;
        }
        if (this.queueStart < this.queueEnd) {
            return this.queueEnd - this.queueStart + 1;
        }
        return this.bpsSpan + this.queueEnd - this.queueStart + 1;
    }

    public double getBps() {
        return this.getBps(false);
    }

    public synchronized double getBps(boolean useCurrentSpeed) {
        if (useCurrentSpeed) {
            if (this.bpsSpan <= 0) {
                return Double.NaN;
            }
            int size = this.queueSize();
            if (size <= 1) {
                return Double.NaN;
            }
            double seconds = (double)(this.queue[this.queueEnd] - this.queue[this.queueStart]) / 1000.0;
            return (double)(size - 1) / seconds;
        }
        if (this.beats == 0L) {
            return Double.NaN;
        }
        return 1000.0 * (double)this.beats / (double)this.getSpendMilliseconds();
    }

    public long getSpendMilliseconds() {
        return this.paused ? this.pauseTime - this.startTime : System.currentTimeMillis() - this.startTime;
    }

    public String getSpendTime() {
        return Profiler.millisecondsToString(this.getSpendMilliseconds());
    }

    public static String millisecondsToString(long ms) {
        int years = (int)Math.floor((double)ms / 3.1536E10);
        ms = (long)((double)ms % 3.1536E10);
        int days = (int)Math.floor((double)ms / 8.64E7);
        ms = (long)((double)ms % 8.64E7);
        int hours = (int)Math.floor((double)ms / 3600000.0);
        ms = (long)((double)ms % 3600000.0);
        int minutes = (int)Math.floor((double)ms / 60000.0);
        ms = (long)((double)ms % 60000.0);
        int seconds = (int)Math.floor((double)ms / 1000.0);
        int milliseconds = (int)((double)ms % 1000.0);
        StringWriter sw = new StringWriter();
        if (years > 0) {
            sw.write(Integer.toString(years));
            sw.write(years == 1 ? " year, " : " years, ");
        }
        if (years > 0 || days > 0) {
            sw.write(Integer.toString(days));
            sw.write(days == 1 ? " day, " : " days, ");
        }
        if (years > 0 || days > 0 || hours > 0) {
            sw.write(Integer.toString(hours));
            sw.write(hours == 1 ? " hour, " : " hours, ");
        }
        if (years > 0 || days > 0 || hours > 0 || minutes > 0) {
            sw.write(Integer.toString(minutes));
            sw.write(minutes == 1 ? " minute, " : " minutes, ");
        }
        if (years > 0 || days > 0 || hours > 0 || minutes > 0 || seconds > 0) {
            sw.write(Integer.toString(seconds));
            sw.write(seconds == 1 ? " second, " : " seconds, ");
        }
        sw.write(Integer.toString(milliseconds));
        sw.write(" ms");
        return sw.toString();
    }

    public long getTimeLeft(boolean useCurrentSpeed) {
        double bps = this.getBps(useCurrentSpeed);
        if (this.expectedTotal == 0L) {
            return -1L;
        }
        if (this.expectedTotal <= this.beats) {
            return 0L;
        }
        return (int)((double)(this.expectedTotal - this.beats) / bps * 1000.0);
    }

    public String getTimeLeftAsString(boolean useCurrentSpeed) {
        long timeLeft = this.getTimeLeft(useCurrentSpeed);
        if (timeLeft == -1L) {
            return "N/A";
        }
        if (timeLeft == 0L) {
            return "None";
        }
        return Profiler.millisecondsToString(timeLeft);
    }

    public Calendar getETA(boolean useCurrentSpeed) {
        long timeLeft = this.getTimeLeft(useCurrentSpeed);
        Calendar calendar = Calendar.getInstance();
        if (timeLeft == -1L) {
            return null;
        }
        if (timeLeft == 0L) {
            return calendar;
        }
        calendar.setTimeInMillis(calendar.getTimeInMillis() + timeLeft);
        return calendar;
    }

    public String getETAAsString(boolean useCurrentSpeed) {
        Calendar eta = this.getETA(useCurrentSpeed);
        if (eta == null) {
            return "N/A";
        }
        return String.format("%1$tF %1$tT", eta);
    }

    public synchronized void pause() {
        if (this.paused) {
            return;
        }
        this.pauseTime = System.currentTimeMillis();
        this.paused = true;
    }

    public synchronized void unpause() {
        if (!this.paused) {
            return;
        }
        long inactiveTime = System.currentTimeMillis() - this.pauseTime;
        if (inactiveTime > 0L) {
            int i = 0;
            while (i < this.queue.length) {
                int n = i++;
                this.queue[n] = this.queue[n] + inactiveTime;
            }
            this.startTime += inactiveTime;
        }
        this.paused = false;
    }
}

