/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.caching;

import dk.statsbiblioteket.util.qa.QAInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class PendingElement<T> {
    private static Log log = LogFactory.getLog(PendingElement.class);
    private T value = null;
    private boolean hasBeenSet = false;

    public PendingElement() {
    }

    public PendingElement(T value) {
        this.value = value;
        this.hasBeenSet = true;
    }

    public synchronized T getValue() {
        if (this.hasBeenSet) {
            return this.value;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting", e);
        }
        return this.value;
    }

    public synchronized T getValue(long ms) {
        if (this.hasBeenSet) {
            return this.value;
        }
        try {
            this.wait(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting", e);
        }
        return this.value;
    }

    public synchronized void setValue(T value) {
        this.value = value;
        this.hasBeenSet = true;
        this.notifyAll();
    }

    public boolean isAssigned() {
        return this.hasBeenSet;
    }
}

