/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.caching;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@QAInfo(state=QAInfo.State.QA_OK, level=QAInfo.Level.NORMAL, author="abr, te")
public class TimeSensitiveCache<K, V>
implements Map<K, V> {
    private BackingCache<K, Cachable<V>> elements;

    public TimeSensitiveCache(long timeToLive, boolean accessOrder, int fixedSize) {
        this.elements = new BackingCache(timeToLive, timeToLive / 10L, fixedSize, accessOrder, true);
    }

    public TimeSensitiveCache(long timeToLive, boolean accessOrder) {
        this.elements = new BackingCache(timeToLive, timeToLive / 10L, 10, accessOrder, false);
    }

    @Override
    public synchronized V get(Object key) {
        Object value = this.elements.get(key);
        if (value != null) {
            return (V)((Cachable)value).getObject();
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.elements.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.elements.keySet();
    }

    @Override
    public Collection<V> values() {
        Collection cachevalues = this.elements.values();
        ArrayList values = new ArrayList(cachevalues.size());
        for (Cachable cachevalue : cachevalues) {
            values.add(cachevalue.getObject());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set cacheentries = this.elements.entrySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>(cacheentries.size());
        for (final Map.Entry cacheentry : cacheentries) {
            Map.Entry entry = new Map.Entry<K, V>(){
                private K key;
                private V value;
                {
                    this.key = cacheentry.getKey();
                    this.value = ((Cachable)cacheentry.getValue()).getObject();
                }

                @Override
                public K getKey() {
                    return this.key;
                }

                @Override
                public V getValue() {
                    return this.value;
                }

                @Override
                public V setValue(V value) {
                    this.value = value;
                    return value;
                }
            };
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public synchronized int size() {
        return this.elements.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.elements.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public synchronized V put(K key, V value) {
        Cachable<V> cacheable = new Cachable<V>(value);
        this.elements.put(key, cacheable);
        return value;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.elements.put(entry.getKey(), new Cachable<V>(entry.getValue()));
        }
    }

    @Override
    public synchronized V remove(Object key) {
        Cachable value = (Cachable)this.elements.remove(key);
        if (value != null) {
            return (V)value.getObject();
        }
        return null;
    }

    private class Cachable<T> {
        private T object;
        private long cacheTime;

        public Cachable(T object, long cacheTime) {
            this.object = object;
            this.cacheTime = cacheTime;
        }

        public Cachable(T object) {
            this.object = object;
            this.cacheTime = System.currentTimeMillis();
        }

        public T getObject() {
            return this.object;
        }

        public long getCacheTime() {
            return this.cacheTime;
        }

        public void refreshCacheTime() {
            this.cacheTime = System.currentTimeMillis();
        }
    }

    private class BackingCache<K, C extends Cachable<V>>
    extends LinkedHashMap<K, C> {
        private int capacity;
        private boolean fixedSize;
        private boolean accessOrder;
        private long timeBetweenGC;
        private long timeToLive;
        private long lastClean;

        public BackingCache(long timeToLive, long timeBetweenGC, int initialCapacity, boolean accessOrder, boolean fixedSize) {
            super(initialCapacity, 0.75f, accessOrder);
            this.capacity = initialCapacity;
            this.accessOrder = accessOrder;
            this.timeBetweenGC = timeBetweenGC;
            this.timeToLive = timeToLive;
            this.capacity = initialCapacity;
            this.fixedSize = fixedSize;
            this.lastClean = System.currentTimeMillis();
        }

        @Override
        public C get(Object key) {
            this.cleanup();
            Cachable value = (Cachable)super.get(key);
            if (this.accessOrder && value != null) {
                value.refreshCacheTime();
            }
            return (C)value;
        }

        @Override
        public boolean containsKey(Object key) {
            Object value = this.get(key);
            return value != null;
        }

        @Override
        public boolean isEmpty() {
            this.cleanup();
            return super.isEmpty();
        }

        @Override
        public int size() {
            this.cleanup();
            return super.size();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, C> eldest) {
            if (this.fixedSize && this.size() > this.capacity) {
                this.remove(eldest.getKey());
            }
            this.cleanup();
            return false;
        }

        private void cleanup() {
            Cachable element;
            if (!this.isTooOld(this.lastClean, this.timeBetweenGC)) {
                return;
            }
            this.lastClean = System.currentTimeMillis();
            if (TimeSensitiveCache.this.elements.isEmpty()) {
                return;
            }
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext() && this.isTooOld((element = (Cachable)iterator.next()).getCacheTime(), this.timeToLive)) {
                iterator.remove();
            }
        }

        private boolean isTooOld(long event, long wait) {
            long now = System.currentTimeMillis();
            return event + wait <= now;
        }
    }
}

