/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.console;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="abr")
public class ProcessRunner
implements Runnable {
    private InputStream processInput = null;
    private InputStream processOutput = null;
    private InputStream processError = null;
    private final List<Thread> threads = Collections.synchronizedList(new LinkedList());
    private final int MAXINITIALBUFFER = 1000000;
    private final int THREADTIMEOUT = 1000;
    private final int POLLING_INTERVAL = 100;
    private final ProcessBuilder pb;
    private long timeout = Long.MAX_VALUE;
    private boolean collect = true;
    private int maxOutput = 31000;
    private int maxError = 31000;
    private int return_code;
    private boolean timedOut;

    public ProcessRunner() {
        this.pb = new ProcessBuilder(new String[0]);
    }

    public ProcessRunner(String command) {
        this();
        ArrayList<String> l = new ArrayList<String>();
        l.add(command);
        this.setCommand(l);
    }

    public ProcessRunner(List<String> commands) {
        this();
        this.setCommand(commands);
    }

    public ProcessRunner(String ... commands) {
        this(Arrays.asList(commands));
    }

    public void setEnviroment(Map<String, String> enviroment) {
        if (enviroment != null) {
            Map<String, String> env = this.pb.environment();
            env.putAll(enviroment);
        }
    }

    public void setInputStream(InputStream processInput) {
        this.processInput = processInput;
    }

    public void setStartingDir(File startingDir) {
        this.pb.directory(startingDir);
    }

    public void setCommand(List<String> commands) {
        this.pb.command(commands);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setCollection(boolean collect) {
        this.collect = collect;
    }

    public void setErrorCollectionByteSize(int maxError) {
        this.maxError = maxError;
    }

    public void setOutputCollectionByteSize(int maxOutput) {
        this.maxOutput = maxOutput;
    }

    public InputStream getProcessOutput() {
        return this.processOutput;
    }

    public InputStream getProcessError() {
        return this.processError;
    }

    public int getReturnCode() {
        return this.return_code;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public String getProcessOutputAsString() {
        return this.getStringContent(this.getProcessOutput());
    }

    public String getProcessErrorAsString() {
        return this.getStringContent(this.getProcessError());
    }

    private void waitForThreads() {
        long endTime = System.currentTimeMillis() + 1000L;
        while (System.currentTimeMillis() < endTime && this.threads.size() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String getStringContent(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(stream, 1000);
        StringWriter sw = new StringWriter(1000);
        try {
            int c;
            while ((c = in.read()) != -1) {
                sw.append((char)c);
            }
            return sw.toString();
        }
        catch (IOException e) {
            return "Could not transform content of stream to String";
        }
    }

    @Override
    public void run() {
        try {
            Process p = this.pb.start();
            if (this.collect) {
                ByteArrayOutputStream pOut = this.collectProcessOutput(p.getInputStream(), this.maxOutput);
                ByteArrayOutputStream pError = this.collectProcessOutput(p.getErrorStream(), this.maxError);
                this.return_code = this.execute(p);
                this.waitForThreads();
                this.processOutput = new ByteArrayInputStream(pOut.toByteArray());
                this.processError = new ByteArrayInputStream(pError.toByteArray());
            } else {
                this.processOutput = p.getInputStream();
                this.processError = p.getErrorStream();
                this.return_code = this.execute(p);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("An io error occurred when running the command", e);
        }
    }

    private int execute(Process p) {
        int return_value;
        long startTime = System.currentTimeMillis();
        this.feedProcess(p, this.processInput);
        while (true) {
            try {
                return_value = p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (System.currentTimeMillis() - startTime > this.timeout) {
                    p.destroy();
                    return_value = -1;
                    this.timedOut = true;
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {}
                continue;
            }
            break;
        }
        return return_value;
    }

    private ByteArrayOutputStream collectProcessOutput(final InputStream inputStream, final int maxCollect) {
        final ByteArrayOutputStream stream = maxCollect < 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(Math.min(1000000, maxCollect));
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedInputStream reader = null;
                    OutputStream writer = null;
                    try {
                        int c;
                        reader = new BufferedInputStream(inputStream);
                        writer = new BufferedOutputStream(stream);
                        int counter = 0;
                        while ((c = ((InputStream)reader).read()) != -1) {
                            if (maxCollect >= 0 && ++counter >= maxCollect) continue;
                            writer.write(c);
                        }
                    }
                    finally {
                        if (reader != null) {
                            ((InputStream)reader).close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't read output from process.", e);
                }
                ProcessRunner.this.threads.remove(this);
            }
        };
        t.setDaemon(true);
        this.threads.add(t);
        t.start();
        return stream;
    }

    private void feedProcess(Process process, InputStream processInput) {
        if (processInput == null) {
            return;
        }
        final OutputStream pIn = process.getOutputStream();
        final InputStream given = processInput;
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedOutputStream writer = null;
                    try {
                        int c;
                        writer = new BufferedOutputStream(pIn);
                        while ((c = given.read()) != -1) {
                            ((OutputStream)writer).write(c);
                        }
                    }
                    finally {
                        if (writer != null) {
                            ((OutputStream)writer).close();
                        }
                        pIn.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't write input to process.", e);
                }
            }
        };
        Thread.UncaughtExceptionHandler u = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
            }
        };
        t.setDaemon(true);
        t.setUncaughtExceptionHandler(u);
        t.start();
    }
}

