/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.i18n;

import dk.statsbiblioteket.util.i18n.EscapeUTF8Stream;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class BundleCache {
    private Log log;
    private Map<String, ResourceBundle> cache = new HashMap<String, ResourceBundle>();
    private static BundleCache self;

    private BundleCache() {
        this.log = LogFactory.getLog(BundleCache.class);
    }

    public static BundleCache getInstance() {
        if (self == null) {
            self = new BundleCache();
            if (BundleCache.self.log.isDebugEnabled()) {
                BundleCache.self.log.debug("Created " + BundleCache.class + " instance");
            }
        }
        return self;
    }

    private static String getLocaleBundleName(String bundleName, Locale locale) {
        return bundleName + "_" + locale.getLanguage() + ".properties";
    }

    private ResourceBundle createBundle(String localeBundleName) {
        InputStream resourceStream;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading '" + localeBundleName + "'");
        }
        if ((resourceStream = ClassLoader.getSystemResourceAsStream(localeBundleName)) == null) {
            throw new MissingResourceException("No such resource '" + localeBundleName + "'", localeBundleName, "");
        }
        try {
            PropertyResourceBundle bundle = new PropertyResourceBundle(new EscapeUTF8Stream(resourceStream));
            this.cache.put(localeBundleName, bundle);
            return bundle;
        }
        catch (IOException e) {
            throw new MissingResourceException("Error reading resource '" + localeBundleName + "'", localeBundleName, "");
        }
    }

    public static synchronized ResourceBundle getBundle(String bundleName, Locale locale) {
        BundleCache self = BundleCache.getInstance();
        String localeBundleName = BundleCache.getLocaleBundleName(bundleName, locale);
        ResourceBundle bundle = self.cache.get(localeBundleName);
        if (bundle != null) {
            if (self.log.isTraceEnabled()) {
                self.log.trace("Found '" + localeBundleName + "' in cache");
            }
            return bundle;
        }
        try {
            return self.createBundle(localeBundleName);
        }
        catch (MissingResourceException e) {
            self.log.debug(e.getMessage() + ". Falling back to '" + bundleName + "'.");
            bundle = self.cache.get(bundleName + ".properties");
            if (bundle != null) {
                return bundle;
            }
            return self.createBundle(bundleName + ".properties");
        }
    }

    public Set<String> getResources() {
        return this.cache.keySet();
    }

    public void clear() {
        this.cache.clear();
    }
}

