/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.reader;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.reader.CircularCharBuffer;
import dk.statsbiblioteket.util.reader.ReplaceReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.NoSuchElementException;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class CharReplacer
extends ReplaceReader {
    private char[] rules;

    public CharReplacer(Reader in, Map<String, String> rules) {
        super(in);
        this.rules = new char[65535];
        for (int c = 0; c < 65535; c = (int)((char)(c + 1))) {
            this.rules[c] = c;
        }
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            char[] target = entry.getKey().toCharArray();
            char[] destination = entry.getValue().toCharArray();
            if (target.length != 1 || destination.length != 1) {
                throw new IllegalArgumentException(String.format("The rule '" + entry.getKey() + "' => '" + entry.getValue() + "' was not single char to single" + " char. The input had length " + entry.getKey().length(), new Object[0]));
            }
            this.rules[target[0]] = destination[0];
        }
    }

    public CharReplacer(Map<String, String> rules) {
        this(new StringReader(""), rules);
    }

    private CharReplacer(char[] rules) {
        super(null);
        this.rules = rules;
    }

    @Override
    public Object clone() {
        return new CharReplacer(this.rules);
    }

    public char transform(char c) {
        return this.rules[c];
    }

    @Override
    public char[] transformToChars(char c) {
        return new char[]{this.rules[c]};
    }

    @Override
    public char[] transformToChars(char[] chars) {
        char[] output = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            output[i] = this.rules[chars[i]];
        }
        return output;
    }

    @Override
    public char[] transformToCharsAllowInplace(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.rules[chars[i]];
        }
        return chars;
    }

    @Override
    public String transform(String s) {
        return new String(this.transformToChars(s.toCharArray()));
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.in != null) {
                int codePoint = this.in.read();
                if (codePoint != -1) {
                    return this.rules[codePoint];
                }
                return -1;
            }
            if (this.sourceBuffer != null) {
                return this.rules[this.sourceBuffer.take()];
            }
            throw new IllegalStateException("Neither sourceReader nor sourceBuffer has been set as source");
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    @Override
    public int read(CircularCharBuffer cbuf, int length) throws IOException {
        int read;
        block7: {
            try {
                if (this.in != null) {
                    for (read = 0; read < length; ++read) {
                        cbuf.put(this.rules[this.in.read()]);
                    }
                    break block7;
                }
                if (this.sourceBuffer != null) {
                    while (read < length) {
                        cbuf.put(this.rules[this.sourceBuffer.take()]);
                        ++read;
                    }
                    break block7;
                }
                throw new IllegalStateException("Neither sourceReader nor sourceBuffer has been set as source");
            }
            catch (NoSuchElementException e) {
                if (length == 0) {
                    return 0;
                }
                return read == 0 ? -1 : read;
            }
        }
        return read;
    }

    @Override
    public int read(char[] cbuf, int off, int length) throws IOException {
        int read;
        block6: {
            try {
                if (this.in != null) {
                    read = this.in.read(cbuf, off, length);
                    this.transformToCharsInplace(cbuf, off, read);
                    break block6;
                }
                if (this.sourceBuffer != null) {
                    for (read = 0; read < length; ++read) {
                        cbuf[off + read] = this.rules[this.sourceBuffer.take()];
                    }
                    break block6;
                }
                throw new IllegalStateException("Neither sourceReader nor sourceBuffer has been set as source");
            }
            catch (NoSuchElementException e) {
                if (length == 0) {
                    return 0;
                }
                return read == 0 ? -1 : read;
            }
        }
        return read;
    }

    private void transformToCharsInplace(char[] chars, int off, int length) {
        for (int i = 0; i < length; ++i) {
            chars[off + i] = this.rules[chars[off + i]];
        }
    }
}

