/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.reader;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.reader.CircularCharBuffer;
import dk.statsbiblioteket.util.reader.ReplaceReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class StringReplacer
extends ReplaceReader {
    private CircularCharBuffer readerBuffer;
    private CircularCharBuffer destinationBuffer;
    private CircularCharBuffer tempInBuffer = new CircularCharBuffer(10, Integer.MAX_VALUE);
    private CircularCharBuffer tempOutBuffer = new CircularCharBuffer(10, Integer.MAX_VALUE);
    private Node tree = new Node();
    private int minBufferSize = 10;
    private boolean eof = false;
    private long replacementsFromCurrentSource = 0L;

    public StringReplacer(Reader in, Map<String, String> replacements) {
        super(in);
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            this.minBufferSize = Math.max(this.minBufferSize, replacement.getKey().length());
            this.tree.addRule(replacement.getKey(), replacement.getValue(), 0);
        }
        this.initBuffers(this.minBufferSize);
    }

    private void initBuffers(int minBufferSize) {
        this.minBufferSize = minBufferSize;
        this.readerBuffer = new CircularCharBuffer(minBufferSize, minBufferSize);
        this.destinationBuffer = new CircularCharBuffer(minBufferSize, Integer.MAX_VALUE);
    }

    public StringReplacer(Map<String, String> replacements) {
        this(new StringReader(""), replacements);
    }

    private StringReplacer(int minBufferSize, Node ruleTree) {
        super(null);
        this.tree = ruleTree;
        this.initBuffers(minBufferSize);
    }

    @Override
    public Object clone() {
        return new StringReplacer(this.minBufferSize, this.tree);
    }

    @Override
    public synchronized char[] transformToChars(char c) {
        this.tempInBuffer.clear();
        this.tempInBuffer.put(c);
        return this.returnReplacement(this.tempInBuffer);
    }

    private char[] returnReplacement(CircularCharBuffer source) {
        this.tempOutBuffer.clear();
        while (source.size() > 0) {
            Node replacement = this.tree.getReplacement(source, 0);
            if (replacement == null) {
                this.tempOutBuffer.put(source.take());
                continue;
            }
            for (int i = 0; i < replacement.from.length(); ++i) {
                source.take();
            }
            this.tempOutBuffer.put(replacement.to);
        }
        return this.tempOutBuffer.takeAll();
    }

    @Override
    public char[] transformToChars(char[] chars) {
        this.tempInBuffer.clear();
        this.tempInBuffer.put(chars);
        return this.returnReplacement(this.tempInBuffer);
    }

    @Override
    public String transform(String s) {
        this.tempInBuffer.clear();
        this.tempInBuffer.put(s.toCharArray());
        return new String(this.returnReplacement(this.tempInBuffer));
    }

    @Override
    public char[] transformToCharsAllowInplace(char[] chars) {
        return this.transformToChars(chars);
    }

    @Override
    public synchronized int read(CircularCharBuffer cbuf, int length) throws IOException {
        this.ensureBuffers(length);
        return this.destinationBuffer.read(cbuf, length);
    }

    @Override
    public synchronized int read() throws IOException {
        this.ensureBuffers(1);
        if (this.destinationBuffer.size() > 0) {
            return this.destinationBuffer.take();
        }
        return -1;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureBuffers(len);
        return this.destinationBuffer.read(cbuf, off, len);
    }

    private void ensureBuffers(int minSize) throws IOException {
        while (this.destinationBuffer.size() < minSize) {
            CircularCharBuffer source = this.getSourceBuffer();
            if (source.size() == 0) {
                return;
            }
            Node replacement = this.tree.getReplacement(source, 0);
            if (replacement == null) {
                this.destinationBuffer.put(source.take());
                continue;
            }
            for (int i = 0; i < replacement.from.length(); ++i) {
                this.readerBuffer.take();
            }
            this.destinationBuffer.put(replacement.to);
            ++this.replacementsFromCurrentSource;
        }
    }

    private CircularCharBuffer getSourceBuffer() throws IOException {
        if (this.sourceBuffer != null) {
            return this.sourceBuffer;
        }
        if (this.in == null) {
            throw new IllegalStateException("Neither sourceReader nor sourceBuffer has been set as source");
        }
        int next = 0;
        while (this.readerBuffer.size() < this.minBufferSize && !this.eof && (next = this.in.read()) != -1) {
            this.readerBuffer.put((char)next);
        }
        if (next == -1) {
            this.eof = true;
        }
        return this.readerBuffer;
    }

    @Override
    public synchronized ReplaceReader setSource(Reader source) {
        super.setSource(source);
        this.readerBuffer.clear();
        this.destinationBuffer.clear();
        this.replacementsFromCurrentSource = 0L;
        this.eof = false;
        return this;
    }

    public long getReplacementCount() {
        return this.replacementsFromCurrentSource;
    }

    private static class Node {
        public char c;
        public String from = null;
        public char[] to = null;
        private Node[] children = new Node[0];
        private boolean root = false;

        public Node() {
            this.root = true;
        }

        public Node(char c) {
            this.c = c;
        }

        public Node getReplacement(CircularCharBuffer buffer) {
            return this.getReplacement(buffer, 0);
        }

        public Node getReplacement(CircularCharBuffer buffer, int level) {
            Node subReplacement;
            char next;
            Node child;
            if (buffer.size() <= level) {
                return null;
            }
            if (this.root) {
                --level;
            }
            if (buffer.size() > level + 1 && (child = this.getChild(next = buffer.peek(level + 1))) != null && (subReplacement = child.getReplacement(buffer, level + 1)) != null) {
                return subReplacement;
            }
            return this.root || this.to == null || buffer.peek(level) != this.c ? null : this;
        }

        public void addRule(String from, String to, int level) {
            if (level >= from.length()) {
                return;
            }
            if (this.root) {
                --level;
            } else if (level + 1 == from.length()) {
                this.from = from;
                this.to = to.toCharArray();
                return;
            }
            char next = from.charAt(level + 1);
            Node child = this.getChild(next);
            if (child == null) {
                child = this.addChild(next);
            }
            child.addRule(from, to, ++level);
        }

        private Node addChild(char next) {
            Node child;
            Node[] newChildren = new Node[this.children.length + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            newChildren[newChildren.length - 1] = child = new Node(next);
            this.children = newChildren;
            return child;
        }

        private Node getChild(char c) {
            for (Node child : this.children) {
                if (child.c != c) continue;
                return child;
            }
            return null;
        }
    }
}

