/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.watch;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.watch.CurrentListener;
import dk.statsbiblioteket.util.watch.FolderEvent;
import dk.statsbiblioteket.util.watch.FolderListener;
import dk.statsbiblioteket.util.watch.FolderWatcher;
import dk.statsbiblioteket.util.watch.Observable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL, author="te")
public class CurrentWatcher
extends Observable<CurrentListener>
implements FolderListener {
    private static Logger log = Logger.getLogger(CurrentWatcher.class);
    private FolderWatcher watcher;
    private Pattern targets;
    private File oldCurrent = null;

    public CurrentWatcher(File watchedFolder, int pollInterval, Pattern targets) throws IOException {
        this.targets = targets;
        this.watcher = new FolderWatcher(watchedFolder, pollInterval);
        this.oldCurrent = this.getCurrentFromFolderWatcher();
        this.watcher.addListener(this);
    }

    public CurrentWatcher(File watchedFolder, int pollInterval, int grace, Pattern targets) throws IOException {
        this.targets = targets;
        this.watcher = new FolderWatcher(watchedFolder, pollInterval, grace);
        this.oldCurrent = this.getCurrentFromFolderWatcher();
        this.watcher.addListener(this);
    }

    private File getCurrentFromFolderWatcher() throws IOException {
        List<File> elements = this.watcher.getContent();
        File latest = null;
        for (File element : elements) {
            if (!this.targets.matcher(element.getName()).matches()) continue;
            latest = element;
        }
        return latest;
    }

    public File getCurrent() {
        return this.oldCurrent;
    }

    @Override
    public void folderChanged(FolderEvent folderEvent) {
        try {
            File newCurrent = this.getCurrentFromFolderWatcher();
            if (this.oldCurrent == null && newCurrent != null || this.oldCurrent != null && !this.oldCurrent.equals(newCurrent)) {
                this.oldCurrent = newCurrent;
                this.alert(newCurrent);
            }
        }
        catch (IOException e) {
            log.error("Exception requesting current folder from FolderWatcher for '" + this.watcher.getWatchedFolder() + "'. No notification is done", e);
        }
    }

    private void alert(File newCurrent) {
        for (CurrentListener listener : this.getListeners()) {
            listener.currentChanged(newCurrent);
        }
    }

    public void addCurrentListener(CurrentListener listener) {
        this.addListener(listener);
    }

    public void removeCurrentListener(CurrentListener listener) {
        this.removeListener(listener);
    }
}

