/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.watch;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.watch.FolderEvent;
import dk.statsbiblioteket.util.watch.FolderListener;
import dk.statsbiblioteket.util.watch.Observable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL, author="te")
public class FolderWatcher
extends Observable<FolderListener>
implements Runnable {
    protected static Logger log = Logger.getLogger(FolderWatcher.class);
    protected File watchedFolder;
    protected List<File> oldContent;
    private int pollInterval;
    private boolean watch = true;
    private static final int DEFAULT_GRACE = 200;
    private int grace;

    public FolderWatcher(File watchedFolder, int pollInterval) throws IOException {
        this(watchedFolder, pollInterval, 200);
    }

    public FolderWatcher(File watchedFolder, int pollInterval, int grace) throws IOException {
        log.debug("Creating watcher for folder '" + watchedFolder + "' with an interval of " + pollInterval + " seconds and a " + "grace period of " + grace + "ms");
        this.watchedFolder = watchedFolder;
        this.pollInterval = pollInterval;
        this.grace = grace;
        this.oldContent = this.getContent();
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @QAInfo(comment="Check if sort on files is an alphanumeric sort")
    public List<File> getContent() throws IOException {
        if (!this.watchedFolder.exists()) {
            log.trace("Watched folder '" + this.watchedFolder + "' does not exist");
            return null;
        }
        log.trace("Returning content of folder '" + this.watchedFolder + "'");
        Object[] content = this.watchedFolder.listFiles();
        Arrays.sort(content);
        return Arrays.asList(content);
    }

    @Override
    public synchronized void run() {
        try {
            while (this.watch) {
                try {
                    List<File> newContent = this.getContent();
                    if (this.oldContent == null && newContent != null) {
                        this.alert(newContent, FolderEvent.EventType.watchedCreated);
                    } else if (this.oldContent != null && newContent == null) {
                        this.alert(newContent, FolderEvent.EventType.watchedRemoved);
                    } else if (this.oldContent != null & newContent != null) {
                        ArrayList<File> added = new ArrayList<File>(newContent);
                        added.removeAll(this.oldContent);
                        if (added.size() > 0) {
                            this.alert(this.getStableContent(this.oldContent), FolderEvent.EventType.added);
                        }
                        ArrayList<File> removed = new ArrayList<File>(this.oldContent);
                        removed.removeAll(newContent);
                        if (removed.size() > 0) {
                            this.alert(removed, FolderEvent.EventType.removed);
                        }
                    }
                    this.oldContent = newContent;
                }
                catch (IOException e) {
                    log.error("An I/O exception occured when polling for changes for folder '" + this.watchedFolder + "'. Polling continues", e);
                }
                try {
                    this.wait(this.pollInterval * 1000);
                }
                catch (InterruptedException e) {
                    log.warn("Sleeping " + this.pollInterval * 1000 + " seconds was " + "interrupted", e);
                }
            }
            log.debug("Stopping watching '" + this.watchedFolder + "'");
        }
        catch (Exception e) {
            log.error("an unexpected exception occured while watching folder '" + this.watchedFolder + "'. Watcher is closing down", e);
        }
    }

    private List<File> getStableContent(List<File> oldContent) throws IOException {
        ArrayList<File> added = new ArrayList<File>(this.getContent());
        added.removeAll(oldContent);
        if (this.grace == 0) {
            return added;
        }
        long lastSize = -1L;
        long currentSize = this.addSizes(added);
        while (lastSize != currentSize) {
            try {
                Thread.sleep(this.grace);
            }
            catch (InterruptedException e) {
                log.warn("Sleeping grace " + this.grace + "ms was interrupted", e);
            }
            added = new ArrayList<File>(this.getContent());
            added.removeAll(oldContent);
            lastSize = currentSize;
            currentSize = this.addSizes(added);
        }
        return added;
    }

    private long addSizes(List<File> files) {
        long total = 0L;
        try {
            for (File file : files) {
                if (!file.isFile() || !file.canRead()) continue;
                total += file.length();
            }
        }
        catch (Exception e) {
            log.warn("Exception counting file sizes. Ignoring and continuing", e);
        }
        return total;
    }

    private void alert(List<File> content, FolderEvent.EventType eventType) {
        log.trace("Alerting " + this.getListeners().size() + " listeners of event " + (Object)((Object)eventType) + " for folder '" + this.watchedFolder + "'");
        FolderEvent event = new FolderEvent(this.watchedFolder, content, eventType);
        for (FolderListener listener : this.getListeners()) {
            listener.folderChanged(event);
        }
    }

    public void close() {
        log.trace("close called for folder '" + this.watchedFolder + "'");
        this.watch = false;
    }

    public File getWatchedFolder() {
        return this.watchedFolder;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void addFolderListener(FolderListener listener) {
        this.addListener(listener);
    }

    public void removeFolderListener(FolderListener listener) {
        this.removeListener(listener);
    }
}

