/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.watch;

import dk.statsbiblioteket.util.Strings;
import dk.statsbiblioteket.util.watch.FolderWatcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class RecursiveFolderWatcher
extends FolderWatcher {
    protected int depth;

    public RecursiveFolderWatcher(File watchedFolder, int depth, int pollInterval, int grace) throws IOException {
        super(watchedFolder, pollInterval, grace);
        this.depth = depth;
        this.oldContent = this.getContent();
    }

    public RecursiveFolderWatcher(File watchedFolder, int depth, int pollInterval) throws IOException {
        super(watchedFolder, pollInterval);
        this.depth = depth;
        this.oldContent = this.getContent();
    }

    @Override
    public List<File> getContent() {
        if (!this.watchedFolder.exists()) {
            log.trace("Watched folder '" + this.watchedFolder + "' does not exist");
            return null;
        }
        log.trace("Returning content of folder '" + this.watchedFolder + "'");
        File[] content = this.watchedFolder.listFiles();
        TreeSet<File> fileBag = new TreeSet<File>();
        for (File f : content) {
            if (f.isDirectory()) {
                this.addContent(f, fileBag, this.depth);
            }
            fileBag.add(f);
        }
        if (log.isTraceEnabled()) {
            log.trace("Contents of " + this.watchedFolder + " to depth " + this.depth + ":\n" + Strings.join(fileBag, "\n"));
        }
        return new ArrayList<File>(fileBag);
    }

    private void addContent(File dir, Set<File> fileBag, int depth) {
        if (depth == 0) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        --depth;
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.addContent(f, fileBag, depth);
                continue;
            }
            fileBag.add(f);
        }
    }
}

