/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.chaos.metadata.migrate.extraction.model;

import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.RadioProgram;
import java.util.ArrayList;
import java.util.List;

public class RadioProgramSearchResultItem {
    private RadioProgram radioProgram;
    private boolean isFilteredOut = false;
    private boolean isExtractionFailed = false;
    private List<String> statusMessages = new ArrayList<String>();

    private RadioProgramSearchResultItem() {
    }

    public RadioProgramSearchResultItem(RadioProgram radioProgramMetadata) {
        this();
        this.radioProgram = radioProgramMetadata;
    }

    public RadioProgram getRadioProgram() {
        return this.radioProgram;
    }

    public boolean validate() {
        boolean validates = true;
        if (this.radioProgram.subClips.isEmpty()) {
            validates = false;
            this.extractionFailed("Validation failed: Empty sub-clips");
        }
        if (this.radioProgram.shardPid == null) {
            validates = false;
            this.extractionFailed("Validation failed: No shard Pid");
        }
        if (this.radioProgram.pbcoreProgramMetadata == null) {
            validates = false;
            this.extractionFailed("Validation failed: No PBCoreMetadata found");
        } else if (this.radioProgram.pbcoreProgramMetadata.channel == null || this.radioProgram.pbcoreProgramMetadata.titel == null || this.radioProgram.pbcoreProgramMetadata.start == null || this.radioProgram.pbcoreProgramMetadata.end == null) {
            validates = false;
            this.extractionFailed("Validation failed: Incomplete PBCoreMetadata");
        }
        return validates;
    }

    public boolean isExtractionSuccessful() {
        return !this.isExtractionFailed;
    }

    private boolean isExtractionFailed() {
        return this.isExtractionFailed;
    }

    public boolean isFilteredOut() {
        return this.isFilteredOut;
    }

    public void extractionFailed(String failStatus) {
        this.isExtractionFailed = true;
        this.statusMessages.add(failStatus);
    }

    public void filteredOut(String filterMessage) {
        this.isFilteredOut = true;
        this.statusMessages.add(filterMessage);
    }

    public boolean isReadyForExport() {
        return !this.isFilteredOut() && !this.isExtractionFailed();
    }

    public String getReasonForNotReadyForExport() {
        String reasons = "";
        int i = 1;
        for (String reason : this.statusMessages) {
            if (i > 1) {
                reasons = reasons + "\n";
            }
            reasons = reasons + "Reason " + i + ": " + reason;
        }
        return reasons;
    }
}

