/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.DigestException;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class Checksums {
    private static final int bufferSize = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digest(String algorithm, InputStream in) throws IOException, NoSuchAlgorithmException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[2048];
            int count = 0;
            while ((count = in.read(buffer)) > 0) {
                md.update(buffer, 0, count);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] digest(String algorithm, byte[] in) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(in);
        return md.digest();
    }

    public static byte[] digest(String algorithm, String in) throws NoSuchAlgorithmException {
        return Checksums.digest(algorithm, in.getBytes());
    }

    public static byte[] digest(String algorithm, File in) throws NoSuchAlgorithmException, IOException {
        return Checksums.digest(algorithm, new BufferedInputStream(new FileInputStream(in)));
    }

    public static byte[] sha1(InputStream in) throws IOException {
        try {
            return Checksums.digest("SHA-1", in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("Unknown algorithm: SHA-1");
        }
    }

    public static byte[] sha1(String in) {
        try {
            return Checksums.digest("SHA-1", in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("Unknown algorithm: SHA-1");
        }
    }

    public static byte[] sha1(File in) throws IOException {
        try {
            return Checksums.digest("SHA-1", in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("Unknown algorithm: SHA-1");
        }
    }

    public static byte[] md5(InputStream in) throws IOException {
        try {
            return Checksums.digest("MD5", in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("Unknown algorithm: MD5");
        }
    }

    public static byte[] md5(String in) {
        try {
            return Checksums.digest("MD5", in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("Unknown algorithm: MD5");
        }
    }

    public static byte[] md5(File in) throws IOException {
        try {
            return Checksums.digest("MD5", in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("Unknown algorithm: MD5");
        }
    }
}

