/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.FileAlreadyExistsException;
import dk.statsbiblioteket.util.FilePermissionException;
import dk.statsbiblioteket.util.InvalidFileTypeException;
import dk.statsbiblioteket.util.Streams;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.log4j.Logger;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class Files {
    private static Logger log = Logger.getLogger(Files.class);

    public static void delete(File path) throws IOException {
        log.trace("delete(" + path + ") called");
        if (!path.exists()) {
            throw new FileNotFoundException(path.toString());
        }
        if (path.isFile()) {
            if (!path.delete()) {
                throw new IOException("Could not delete the file '" + path + "'");
            }
            return;
        }
        for (String child : path.list()) {
            Files.delete(new File(path, child));
        }
        path.delete();
    }

    public static void copy(File path, File toPath, boolean overwrite) throws IOException {
        log.trace("copy(" + path + ", " + toPath + ", " + overwrite + ")");
        if (path.isFile()) {
            Files.copyFile(path, toPath, overwrite);
        } else if (path.isDirectory()) {
            if (!toPath.exists()) {
                Files.copyDirectory(path, toPath, overwrite);
            } else {
                Files.copyDirectory(path, new File(toPath, path.getName()), overwrite);
            }
        }
    }

    public static void move(File source, File dest, boolean overwrite) throws IOException {
        if (source == null) {
            throw new NullPointerException("Move source location is null");
        }
        if (dest == null) {
            throw new NullPointerException("Move destination is null");
        }
        if (!source.exists()) {
            throw new FileNotFoundException(source.toString());
        }
        if (!source.canWrite()) {
            throw new FilePermissionException(source, Permission.writable);
        }
        File destParent = dest.getParentFile();
        if (dest.exists() && dest.isFile() && !overwrite) {
            throw new FileAlreadyExistsException(dest);
        }
        if (!destParent.exists()) {
            throw new FileNotFoundException("Parent directory of " + dest + " " + "does not exist");
        }
        if (destParent.isFile()) {
            throw new InvalidFileTypeException(destParent, Type.file);
        }
        if (dest.isFile() && !destParent.canWrite()) {
            throw new FilePermissionException(destParent, Permission.writable);
        }
        if (dest.isDirectory()) {
            if (!dest.canWrite()) {
                throw new FilePermissionException(dest, Permission.writable);
            }
            dest = new File(dest, Files.baseName(source));
        }
        if (dest.exists()) {
            if (!overwrite) {
                throw new FileAlreadyExistsException(dest);
            }
            log.trace("Overwriting " + dest);
            Files.delete(dest);
        }
        log.trace("Set to move " + source + " to " + dest);
        boolean result = false;
        for (int i = 0; i < 10 && !(result = source.renameTo(dest)); ++i) {
            System.gc();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                break;
            }
            log.trace("Retrying move (" + i + ")");
        }
        if (!result) {
            log.debug("Atomic move failed. Falling back to copy/delete");
            Files.copy(source, dest, overwrite);
            Files.delete(source);
        }
        log.debug("Moved " + source + " to " + dest);
    }

    public static void move(File source, File dest) throws IOException {
        Files.move(source, dest, false);
    }

    private static void innerCopy(File path, File toPath, boolean overwrite) throws IOException {
        if (path.isFile()) {
            Files.copyFile(path, toPath, overwrite);
        } else if (path.isDirectory()) {
            Files.copyDirectory(path, toPath, overwrite);
        }
    }

    private static void copyDirectory(File path, File toPath, boolean overwrite) throws IOException {
        log.trace("copyDirectory(" + path + ", " + toPath + ", " + overwrite + ") called");
        if (!toPath.exists() && !toPath.mkdirs()) {
            throw new IOException("Unable to create or verify the existence of the destination folder '" + toPath.getAbsoluteFile() + "'");
        }
        if (!toPath.canWrite()) {
            throw new IOException("The destination folder '" + toPath.getAbsoluteFile() + "' is not writable");
        }
        for (String filename : path.list()) {
            File in = new File(path, filename);
            File out = new File(toPath, filename);
            Files.innerCopy(in, out, overwrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File destination, boolean overwrite) throws IOException {
        log.trace("copyFile(" + source + ", " + destination + ", " + overwrite + ") called");
        source = source.getAbsoluteFile();
        destination = destination.getAbsoluteFile();
        if (!source.exists()) {
            throw new FileNotFoundException("The source '" + source + "' does not exist");
        }
        if (destination.isDirectory()) {
            throw new IOException("The destination '" + destination + "' is a directory");
        }
        if (destination.exists() && destination.isDirectory()) {
            destination = new File(destination, source.getName());
        }
        if (!overwrite && destination.exists()) {
            throw new FileAlreadyExistsException(destination.toString());
        }
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        try {
            byte[] buf = new byte[2028];
            int count = 0;
            while ((count = ((InputStream)in).read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, count);
            }
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        destination.setExecutable(source.canExecute());
    }

    public static void delete(String path) throws IOException {
        Files.delete(new File(path));
    }

    private static String bytesToString(byte[] in) {
        try {
            return new String(in, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("utf-8 not supported", e);
        }
    }

    public static void saveString(String content, File destination) throws IOException {
        log.trace("saveString(String with length " + content.length() + ", " + destination + ") called");
        if (destination.isDirectory()) {
            throw new IOException("The destination '" + destination + "' is a folder, while it should be a file");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("UTF-8"));
        FileOutputStream out = new FileOutputStream(destination);
        Streams.pipeStream(in, out);
    }

    public static String loadString(File source) throws IOException {
        if (source.isDirectory()) {
            throw new IOException("The source '" + source + "' is a folder, while it should be a file");
        }
        FileInputStream in = new FileInputStream(source);
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)source.length());
        Streams.pipeStream(in, out);
        return out.toString("UTF-8");
    }

    public static String baseName(File file) {
        return Files.baseName(file.toString());
    }

    public static String baseName(String filename) {
        return filename.substring(filename.lastIndexOf(File.separator) + 1);
    }

    public static File download(URL url, File target, boolean overwrite) throws IOException {
        InputStream con;
        log.trace("download(" + url + ", " + target + ", " + overwrite + ") called");
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        File result = target.isDirectory() ? new File(target, Files.baseName(new File(url.getFile()))) : target;
        if (result.exists() && !overwrite) {
            throw new FileAlreadyExistsException(target);
        }
        try {
            con = url.openStream();
        }
        catch (IOException e) {
            throw new IOException("Failed to open stream to '" + url + "'", e);
        }
        FileOutputStream out = new FileOutputStream(result);
        Streams.pipeStream(con, out);
        return result;
    }

    public static File download(URL url, File target) throws IOException {
        return Files.download(url, target, false);
    }

    public static enum Permission {
        readable,
        writable,
        executable;

    }

    public static enum Type {
        directory,
        file;

    }
}

