/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import org.apache.log4j.Logger;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class LineReader
implements DataInput,
DataOutput {
    private static Logger log = Logger.getLogger(LineReader.class);
    protected static final int BUFFER_SIZE = 8192;
    private RandomAccessFile input;
    private FileChannel channelIn;
    private boolean inOpen = false;
    private RandomAccessFile output;
    private FileChannel channelOut;
    private boolean outOpen = false;
    private ByteBuffer buffer;
    private long bufferStart = -1L;
    private int maxBufferPos = 0;
    private File file;
    private long position = 0L;
    private boolean dirty = false;
    private long fileSize = -1L;
    private boolean writable = false;
    private boolean synchronize = false;
    private int bufferSize;
    private byte[] readBuf = new byte[8];
    private ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream(400);
    private byte[] outBytes = new byte[8];

    public LineReader(File file, String mode) throws IOException {
        if (mode != null && mode.contains("w") && !file.exists()) {
            log.trace("Creating file '" + file + "'");
            file.createNewFile();
        }
        if (mode == null) {
            log.debug("Mode == null, defaulting to read-only");
        } else if (mode.equals("r")) {
            this.writable = false;
        } else if (mode.equals("rw")) {
            this.writable = true;
        } else if (mode.equals("rws")) {
            this.writable = true;
            this.synchronize = true;
        } else if (mode.equals("rwd")) {
            this.writable = true;
            this.synchronize = true;
        } else {
            throw new IllegalArgumentException("The mode '" + mode + "' is " + "illegal. Legal values are " + "'r', 'rw', 'rws' and 'rwd");
        }
        if (this.writable && !file.canWrite()) {
            throw new IOException("The file '" + file + "' is read-only");
        }
        this.file = file;
        this.setBufferSize(8192);
    }

    public void setBufferSize(int bufferSize) throws IOException {
        this.invalidateBuffer();
        this.bufferSize = bufferSize;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    public long getPosition() {
        return this.position;
    }

    public long getFilePointer() {
        return this.getPosition();
    }

    public void seek(long position) throws IOException {
        if (position > this.length()) {
            throw new EOFException("Cannot set position " + position + " as the file size is only " + this.length() + " bytes");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("The position cannot be negative");
        }
        if (this.bufferStart != -1L) {
            if (position < this.bufferStart || position >= this.bufferStart + (long)this.bufferSize) {
                this.invalidateBuffer();
            } else {
                try {
                    this.buffer.position((int)(position - this.bufferStart));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Trying to set the buffer position to " + position + " - " + this.bufferStart + " = " + (position - this.bufferStart) + " with a buffer of size " + this.getBufferSize(), e);
                }
            }
        }
        this.position = position;
    }

    public long length() {
        if (this.fileSize == -1L) {
            this.fileSize = this.file.length();
        }
        return Math.max(this.fileSize, this.dirty ? this.bufferStart + (long)this.maxBufferPos : this.fileSize);
    }

    public void reset() throws IOException {
        this.close();
    }

    private void checkInputFile() throws IOException {
        if (this.inOpen) {
            return;
        }
        log.trace("Opening input channel for '" + this.file + "'");
        this.input = new RandomAccessFile(this.file, "r");
        this.channelIn = this.input.getChannel();
        this.seek(this.position);
        this.inOpen = true;
    }

    private void checkOutputFile() throws IOException {
        if (!this.writable) {
            throw new IllegalStateException(String.format("The file '%s' has been opened in read-only mode", this.file));
        }
        if (this.outOpen) {
            return;
        }
        log.trace("Opening output channel for '" + this.file + "'");
        this.output = new RandomAccessFile(this.file, "rw");
        this.channelOut = this.output.getChannel();
        this.outOpen = true;
    }

    public void close() throws IOException {
        this.closeNoReset();
        this.position = 0L;
    }

    private void closeNoReset() throws IOException {
        this.invalidateBuffer();
        if (this.channelIn != null) {
            this.channelIn.close();
        }
        if (this.input != null) {
            this.input.close();
        }
        this.inOpen = false;
        if (this.channelOut != null) {
            this.channelOut.close();
        }
        if (this.output != null) {
            this.output.close();
        }
        this.outOpen = false;
    }

    private void checkBuffer() throws IOException {
        if (this.bufferStart == -1L) {
            if (this.dirty) {
                log.error("The buffer should not be dirty when bufferStart == -1");
            }
            this.checkInputFile();
            log.trace("checkBuffer: Seeking to position " + this.position);
            this.buffer.limit(this.buffer.capacity());
            this.channelIn.position(this.position);
            this.buffer.clear();
            int readBytes = this.channelIn.read(this.buffer, this.position);
            log.trace("checkBuffer: mapped " + readBytes + " bytes to buffer");
            this.buffer.position(0);
            this.bufferStart = this.position;
        }
    }

    private void invalidateBuffer() throws IOException {
        this.flush();
        this.bufferStart = -1L;
    }

    private void flushIfNeeded() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this.dirty) {
            assert (this.bufferStart != -1L) : "When the buffer is dirty, bufferStart should be >= 0";
            log.trace("Storing the buffer to disk");
            this.checkOutputFile();
            if (log.isTraceEnabled()) {
                log.trace("flush: bufferStart=" + this.bufferStart + ", maxBufferPos=" + this.maxBufferPos + ", buffer.limit=" + this.buffer.limit() + ", position=" + this.position);
            }
            this.buffer.position(this.maxBufferPos);
            this.buffer.flip();
            this.channelOut.position(this.bufferStart);
            this.channelOut.write(this.buffer);
            this.dirty = false;
            this.buffer.clear();
            this.bufferStart = -1L;
            this.fileSize = -1L;
            this.maxBufferPos = 0;
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean eof() {
        return this.position >= this.length();
    }

    public int read() throws IOException {
        try {
            return this.readByte() & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this.readByte() << 8 | this.readByte());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readByte() << 8 | this.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return (char)(this.readByte() << 8 | this.readByte());
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this.readBuf, 0, 4);
        return (this.readBuf[0] & 0xFF) << 24 | (this.readBuf[1] & 0xFF) << 16 | (this.readBuf[2] & 0xFF) << 8 | this.readBuf[3];
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.readBuf, 0, 8);
        return (long)(this.readBuf[0] & 0xFF) << 56 | (long)(this.readBuf[1] & 0xFF) << 48 | (long)(this.readBuf[2] & 0xFF) << 40 | (long)(this.readBuf[3] & 0xFF) << 32 | (long)(this.readBuf[4] & 0xFF) << 24 | (long)(this.readBuf[5] & 0xFF) << 16 | (long)(this.readBuf[6] & 0xFF) << 8 | (long)this.readBuf[7];
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readInt());
    }

    @Override
    public byte readByte() throws IOException {
        this.checkInputFile();
        this.checkBuffer();
        if (this.eof()) {
            throw new EOFException("Attempted to read past EOF");
        }
        byte b = this.buffer.get();
        ++this.position;
        if (this.position >= this.bufferStart + (long)this.bufferSize) {
            this.invalidateBuffer();
        }
        return b;
    }

    @Override
    public String readLine() throws IOException {
        this.lineBuffer.reset();
        while (true) {
            byte next;
            try {
                next = this.readByte();
            }
            catch (EOFException e) {
                log.trace("Reached EOF in readLine()");
                break;
            }
            if (next == 10) {
                if (!log.isTraceEnabled()) break;
                log.trace("Read " + this.lineBuffer.size() + " bytes in readLine");
                break;
            }
            this.lineBuffer.write(next);
        }
        return this.lineBuffer.toString("utf-8");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public void readFully(byte[] buf, int offset, int length) throws IOException {
        int got = this.read(buf, offset, length);
        if (got < length) {
            throw new EOFException("Reached end of file '" + this.file + "' at " + this.position + " with " + (length - got) + " bytes yet to read");
        }
        if (log.isTraceEnabled()) {
            log.trace("Read " + length + " bytes from file '" + this.file + "' from offset " + (this.position - (long)length) + " to " + this.position);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long skip = Math.min((long)n, this.length() - this.position);
        log.trace("Skipping " + skip + " bytes out of " + n + " wanted");
        this.seek(this.position + skip);
        return (int)skip;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int read;
        for (read = 0; read < length; ++read) {
            if (this.eof()) {
                return read == 0 ? -1 : read;
            }
            buf[offset++] = this.readByte();
        }
        return read;
    }

    public void write(String str) throws IOException {
        this.write(str.getBytes("utf-8"));
    }

    @Override
    public void write(int value) throws IOException {
        this.checkInputFile();
        this.checkBuffer();
        this.buffer.put((byte)(value & 0xFF));
        this.dirty = true;
        this.maxBufferPos = Math.max(this.maxBufferPos, this.buffer.position());
        ++this.position;
        this.flushIfNeeded();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        if (offset + length > buf.length) {
            throw new IllegalArgumentException("Out of bounds: buf.length=" + buf.length + " offset=" + offset + " length=" + length);
        }
        log.trace("write: Writing " + (length - offset) + " bytes at position " + this.position);
        this.checkInputFile();
        int left = length;
        while (left > 0) {
            this.checkBuffer();
            int writeLength = Math.min(left, this.bufferSize - this.buffer.position());
            if (log.isTraceEnabled()) {
                log.trace("write: buf.length=" + buf.length + ", offset=" + offset + ", length=" + length + ", writeLength=" + writeLength + ", bufferStart=" + this.bufferStart + ", buffer.position()=" + this.buffer.position() + ", position=" + this.position);
            }
            try {
                this.buffer.put(buf, offset, writeLength);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException("Buffer break while writing " + writeLength + " bytes from offset " + offset + " in a buf with length " + buf.length);
            }
            left -= writeLength;
            offset += writeLength;
            this.maxBufferPos = Math.max(this.maxBufferPos, this.buffer.position());
            this.dirty = true;
            this.position += (long)writeLength;
            this.fileSize += (long)writeLength;
            this.flushIfNeeded();
        }
        if (log.isTraceEnabled()) {
            log.trace("write: Wrote " + length + " bytes to file '" + this.file + "'");
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.outBytes[0] = (byte)(0xFF & v >> 8);
        this.outBytes[1] = (byte)(0xFF & v);
        this.write(this.outBytes, 0, 2);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.outBytes[0] = (byte)(0xFF & v >> 8);
        this.outBytes[1] = (byte)(0xFF & v);
        this.write(this.outBytes, 0, 2);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.outBytes[0] = (byte)(0xFF & v >> 24);
        this.outBytes[1] = (byte)(0xFF & v >> 16);
        this.outBytes[2] = (byte)(0xFF & v >> 8);
        this.outBytes[3] = (byte)(0xFF & v);
        this.write(this.outBytes, 0, 4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.outBytes[0] = (byte)(0xFFL & v >> 56);
        this.outBytes[1] = (byte)(0xFFL & v >> 48);
        this.outBytes[2] = (byte)(0xFFL & v >> 40);
        this.outBytes[3] = (byte)(0xFFL & v >> 32);
        this.outBytes[4] = (byte)(0xFFL & v >> 24);
        this.outBytes[5] = (byte)(0xFFL & v >> 16);
        this.outBytes[6] = (byte)(0xFFL & v >> 8);
        this.outBytes[7] = (byte)(0xFFL & v);
        this.write(this.outBytes, 0, 8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        char[] cBuf = s.toCharArray();
        byte[] bBuf = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            bBuf[i] = (byte)(cBuf[i] & 0xFF);
        }
        this.write(bBuf);
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] cBuf = s.toCharArray();
        byte[] bBuf = new byte[s.length() * 2];
        for (int i = 0; i < s.length(); ++i) {
            bBuf[i * 2] = (byte)(cBuf[i] >> 8 & 0xFF);
            bBuf[i * 2 + 1] = (byte)(cBuf[i] & 0xFF);
        }
        this.write(bBuf);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        throw new UnsupportedEncodingException("This is not supported as the necessary util is package private in DataOutputStream");
    }

    public long binaryLineSearch(Comparator<String> comparator, String query) throws IOException {
        long low = 0L;
        long high = this.length() - 1L;
        while (low <= high) {
            int cmp;
            long mid = low + high >>> 1;
            this.seek(mid);
            if (mid != 0L) {
                while (!this.eof() && this.readByte() != 10) {
                }
            }
            if (this.eof()) {
                high = mid - 1L;
                continue;
            }
            long lineStart = this.getPosition();
            String line = this.readLine();
            int n = cmp = comparator == null ? query.compareTo(line) : comparator.compare(query, line);
            if (cmp < 0) {
                high = mid - 1L;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1L;
                continue;
            }
            return lineStart;
        }
        return -(low + 1L);
    }
}

