/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class Strings {
    private static final ThreadLocal<StringBuilder> localBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }

        @Override
        public StringBuilder get() {
            StringBuilder b = (StringBuilder)super.get();
            b.setLength(0);
            return b;
        }
    };
    private static final ThreadLocal<char[]> localBuffer = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };

    public static String getStackTrace(Throwable exception) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        exception.printStackTrace(printer);
        return writer.toString();
    }

    public static String join(Collection c, String delimiter) {
        if (c == null) {
            throw new NullPointerException("Collection argument is null");
        }
        if (delimiter == null) {
            throw new NullPointerException("Delimiter argument is null");
        }
        StringBuilder b = localBuilder.get();
        for (Object o : c) {
            if (b.length() == 0) {
                b.append(o == null ? "" : o.toString());
                continue;
            }
            b.append(delimiter);
            b.append(o == null ? "" : o.toString());
        }
        return b.toString();
    }

    public static String join(Object[] a, String delimiter) {
        if (a == null) {
            throw new NullPointerException("Collection argument is null");
        }
        if (delimiter == null) {
            throw new NullPointerException("Delimiter argument is null");
        }
        StringBuilder b = localBuilder.get();
        for (Object o : a) {
            if (b.length() == 0) {
                b.append(o == null ? "" : o.toString());
                continue;
            }
            b.append(delimiter);
            b.append(o == null ? "" : o.toString());
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String flush(Reader r) throws IOException {
        char[] buf = localBuffer.get();
        StringBuilder b = localBuilder.get();
        try {
            int numRead;
            while ((numRead = r.read(buf)) != -1) {
                b.append(buf, 0, numRead);
            }
        }
        finally {
            r.close();
        }
        return b.toString();
    }

    public static String flush(InputStream in) throws IOException {
        return Strings.flush(new InputStreamReader(in));
    }

    public static String flushLocal(Reader r) {
        try {
            return Strings.flush(r);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException when reading character stream", e);
        }
    }

    public static String flushLocal(InputStream in) {
        return Strings.flushLocal(new InputStreamReader(in));
    }

    public static CharSequence asCharSequence(final char[] chars) {
        return new CharSequence(){

            @Override
            public int length() {
                return chars.length;
            }

            @Override
            public char charAt(int index) {
                return chars[index];
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return Strings.asCharSequence(Arrays.copyOfRange(chars, start, end));
            }

            @Override
            public String toString() {
                return new String(chars);
            }
        };
    }

    public static int indexOf(char c, CharSequence chars) {
        return Strings.indexOf(c, 0, chars);
    }

    public static int indexOf(char c, int offset, CharSequence chars) {
        for (int i = offset; i < chars.length(); ++i) {
            if (c != chars.charAt(i)) continue;
            return i;
        }
        return -1;
    }
}

