/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.FileAlreadyExistsException;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class Zips {
    public static void zip(String path, String outputFilename, boolean overwrite) throws IOException {
        File outFile = new File(outputFilename);
        if (!overwrite && outFile.exists()) {
            throw new FileAlreadyExistsException(outputFilename);
        }
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            throw new IOException("Error creating '" + outFile.getParentFile() + "'");
        }
        FileOutputStream fileWriter = new FileOutputStream(outputFilename);
        ZipOutputStream zipStream = new ZipOutputStream(fileWriter);
        Zips.addToZip("", path, zipStream);
        zipStream.flush();
        zipStream.finish();
        zipStream.close();
        fileWriter.flush();
        fileWriter.close();
    }

    public static void unzip(String zipFilename, String outputDir, boolean overwrite) throws IOException {
        ZipEntry entry;
        File outputFileDir = new File(outputDir);
        if (!outputFileDir.exists() && !outputFileDir.mkdirs()) {
            throw new IOException("Error creating output directory '" + outputDir + "'");
        }
        FileInputStream fis = new FileInputStream(zipFilename);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            byte[] data = new byte[2048];
            String newFile = outputDir + File.separator + entry.getName();
            if (!overwrite && new File(newFile).exists()) {
                throw new FileAlreadyExistsException(newFile);
            }
            new File(newFile).getParentFile().mkdirs();
            if (newFile.endsWith(File.separator)) {
                new File(newFile).mkdir();
                continue;
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, data.length);
            while ((count = zis.read(data, 0, data.length)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
    }

    private static void addToZip(String parentPath, String filename, ZipOutputStream zipStream) throws IOException {
        File file = new File(filename);
        if (file.isDirectory()) {
            Zips.addFolderToZip(parentPath, filename, zipStream);
        } else {
            int len;
            byte[] buf = new byte[4096];
            if (parentPath.equals("")) {
                zipStream.putNextEntry(new ZipEntry(file.getName()));
            } else {
                zipStream.putNextEntry(new ZipEntry(parentPath + File.separator + file.getName()));
            }
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buf)) > 0) {
                zipStream.write(buf, 0, len);
            }
        }
    }

    private static void addFolderToZip(String parentPath, String filename, ZipOutputStream zipStream) throws IOException {
        File folder = new File(filename);
        for (String child : folder.list()) {
            if (parentPath.equals("")) {
                Zips.addToZip(folder.getName(), filename + File.separator + child, zipStream);
                continue;
            }
            Zips.addToZip(parentPath + File.separator + folder.getName(), filename + File.separator + child, zipStream);
        }
    }

    public static byte[] gunzipBuffer(byte[] data) {
        try {
            int size;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] buf = new byte[2048];
            while ((size = in.read(buf)) > 0) {
                out.write(buf, 0, size);
            }
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while gzipping buffer. This should never happen", e);
        }
    }

    public static byte[] gzipBuffer(byte[] data) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            GZIPOutputStream zip = new GZIPOutputStream(buf);
            zip.write(data);
            zip.close();
            return buf.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while gunzipping buffer. This should never happen", e);
        }
    }

    public static byte[] getZipEntry(File zipFile, String entryName) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(new FileInputStream(zipFile));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((entry = zip.getNextEntry()) != null) {
            if (entry.getName().equals(entryName)) {
                int count;
                while ((count = zip.read(buf, 0, buf.length)) != -1) {
                    out.write(buf, 0, count);
                }
                return out.toByteArray();
            }
            zip.closeEntry();
        }
        return null;
    }
}

