/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.caching;

import dk.statsbiblioteket.util.caching.PendingElement;
import dk.statsbiblioteket.util.caching.TimeSensitiveCache;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class PendingCache<V, T>
implements Map<V, T> {
    private static Log log = LogFactory.getLog(PendingCache.class);
    private final TimeSensitiveCache<V, PendingElement<T>> inner;

    public PendingCache(long timeToLive, boolean accessOrder, int fixedSize) {
        this.inner = new TimeSensitiveCache(timeToLive, accessOrder, fixedSize);
    }

    public PendingCache(long timeToLive, boolean accessOrder) {
        this.inner = new TimeSensitiveCache(timeToLive, accessOrder);
    }

    @Override
    public T get(Object key) {
        PendingElement<T> element = this.inner.get(key);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public T get(V key, long ms) {
        PendingElement<T> element = this.inner.get(key);
        if (element == null) {
            return null;
        }
        return element.getValue(ms);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<V, PendingElement<T>> entry : this.inner.entrySet()) {
            if (!entry.getValue().isAssigned() || (entry.getValue() != null || value != null) && (entry.getValue() == null || !entry.getValue().equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized T put(V key, T value) {
        PendingElement<T> old = this.inner.put((PendingElement<T>)key, new PendingElement<T>(value));
        if (old != null && old.isAssigned()) {
            return old.getValue();
        }
        return null;
    }

    public synchronized PendingElement<T> putPending(V key) {
        PendingElement pending = new PendingElement();
        this.inner.put(key, pending);
        return pending;
    }

    @Override
    public Collection<T> values() {
        ArrayList<T> result = new ArrayList<T>(this.size());
        for (Map.Entry<V, PendingElement<T>> entry : this.inner.entrySet()) {
            if (!entry.getValue().isAssigned() || entry.getValue() == null) continue;
            result.add(entry.getValue().getValue());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<V, T>> entrySet() {
        HashSet<Map.Entry<V, T>> result = new HashSet<Map.Entry<V, T>>(this.size());
        for (Map.Entry<V, PendingElement<T>> entry : this.inner.entrySet()) {
            if (!entry.getValue().isAssigned() || entry.getValue() == null) continue;
            final Map.Entry<V, PendingElement<T>> fEntry = entry;
            Map.Entry newEntry = new Map.Entry<V, T>(){
                private V key;
                private T value;
                {
                    this.key = fEntry.getKey();
                    this.value = ((PendingElement)fEntry.getValue()).getValue();
                }

                @Override
                public V getKey() {
                    return this.key;
                }

                @Override
                public T getValue() {
                    return this.value;
                }

                @Override
                public T setValue(T value) {
                    Object oldValue = this.value;
                    this.value = value;
                    return oldValue;
                }
            };
            result.add(newEntry);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends V, ? extends T> m) {
        for (Map.Entry<V, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public T remove(Object key) {
        PendingElement<T> pending = this.inner.remove(key);
        if (pending == null || !pending.isAssigned()) {
            return null;
        }
        return pending.getValue();
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public Set<V> keySet() {
        return this.inner.keySet();
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }
}

