/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.console;

import dk.statsbiblioteket.util.console.Color;
import dk.statsbiblioteket.util.console.Hint;
import java.io.IOException;

public class Formatter {
    private Color foreground;
    private Color background;
    private Hint hint;
    private static final String controlStart = "\u001b[";
    private static final String controlEnd = "m";

    public Formatter() {
    }

    public Formatter(Color fg) {
        this.foreground = fg;
    }

    public Formatter(Color fg, Color bg) {
        this.foreground = fg;
        this.background = bg;
    }

    public Formatter(Color fg, Color bg, Hint hint) {
        this.foreground = fg;
        this.background = bg;
        this.hint = hint;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setHint(Hint hint) {
        this.hint = hint;
    }

    public void reset() {
        this.hint = null;
        this.background = null;
        this.foreground = null;
    }

    public String format(String s) {
        StringBuilder buf = new StringBuilder();
        try {
            this.format(s, buf);
        }
        catch (IOException e) {
            return "Error: " + e.getMessage();
        }
        return buf.toString();
    }

    public Appendable format(String s, Appendable buf) throws IOException {
        if (this.foreground == null && this.background == null && this.hint == null) {
            buf.append(s);
            return buf;
        }
        buf.append(controlStart);
        if (this.foreground != null) {
            buf.append(Integer.toString(30 + this.foreground.ordinal()));
        }
        if (this.background != null) {
            buf.append(this.foreground != null ? ";" : "");
            buf.append(Integer.toString(40 + this.background.ordinal()));
        }
        if (this.hint != null) {
            buf.append(this.background != null || this.foreground != null ? ";" : "");
            buf.append(Integer.toString(this.hint.ordinal()));
        }
        buf.append(controlEnd);
        buf.append(s);
        buf.append(controlStart).append("0").append(controlEnd);
        return buf;
    }
}

