/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.console;

import dk.statsbiblioteket.util.console.Formatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Table {
    private List<String> columns;
    private boolean printHeaders;
    private Model model;
    private String delimiter;
    private Formatter headerFormatter;
    private Formatter dataFormatter;
    private Formatter delimFormatter;

    public Table(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
        this.printHeaders = true;
        this.model = new Model();
        this.delimiter = " ";
    }

    public Table(String ... columns) {
        this(Arrays.asList(columns));
    }

    public void setPrintHeaders(boolean printHeaders) {
        this.printHeaders = printHeaders;
    }

    public void setDelimiter(String delim) {
        this.delimiter = delim;
    }

    public Table setHeaderFormatter(Formatter formatter) {
        this.headerFormatter = formatter;
        return this;
    }

    public Table setDataFormatter(Formatter formatter) {
        this.dataFormatter = formatter;
        return this;
    }

    public Table setDelimiterFormatter(Formatter formatter) {
        this.delimFormatter = formatter;
        return this;
    }

    public void setColumns(String ... columns) {
        this.setColumns(Arrays.asList(columns));
    }

    public void setColumns(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    public void appendColumns(String ... cols) {
        this.columns.addAll(Arrays.asList(cols));
    }

    public Model getModel() {
        return this.model;
    }

    public void appendRow(String ... data) {
        this.model.appendRow(data);
    }

    public void appendData(String ... data) {
        this.model.appendData(data);
    }

    public Appendable print(Appendable buf) throws IOException {
        if (this.printHeaders) {
            for (String col : this.columns) {
                this.pad(buf, col, col, this.headerFormatter);
                if (this.headerFormatter == null) {
                    buf.append(this.delimiter);
                    continue;
                }
                this.headerFormatter.format(this.delimiter, buf);
            }
            buf.append("\n");
        }
        for (Map row : this.model) {
            for (String col : this.columns) {
                String data = (String)row.get(col);
                this.pad(buf, col, data, this.dataFormatter);
                if (this.delimFormatter == null) {
                    buf.append(this.delimiter);
                    continue;
                }
                this.delimFormatter.format(this.delimiter, buf);
            }
            buf.append("\n");
        }
        return buf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            this.print(buf);
        }
        catch (IOException e) {
            buf.append("Error: ");
            buf.append(e.getMessage());
        }
        return buf.toString();
    }

    private int getColumnWidth(String col) {
        if (this.printHeaders) {
            return Math.max(this.model.columnWidth(col), col.length());
        }
        return this.model.columnWidth(col);
    }

    private Appendable pad(Appendable buf, String column, String data, Formatter f) throws IOException {
        data = data != null ? data : "null";
        int num = this.getColumnWidth(column) - data.length();
        if (num <= 0) {
            if (f == null) {
                return buf.append(data);
            }
            return f.format(data, buf);
        }
        if (f == null) {
            buf.append(data);
        } else {
            f.format(data, buf);
        }
        for (int i = 0; i < num; ++i) {
            if (f == null) {
                buf.append(" ");
                continue;
            }
            f.format(" ", buf);
        }
        return buf;
    }

    public static class Model
    implements Iterable<Map<String, String>> {
        private List<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        private Map<String, Integer> columnWidths = new HashMap<String, Integer>();

        public Map<String, String> appendRow(String ... data) {
            if (data.length % 2 != 0) {
                throw new IllegalArgumentException("Uneven number of args " + data.length);
            }
            HashMap<String, String> row = new HashMap<String, String>();
            for (int i = 0; i < data.length; i += 2) {
                row.put(data[i], data[i + 1]);
                int oldWidth = this.columnWidths.containsKey(data[i]) ? this.columnWidths.get(data[i]) : 0;
                int valueLength = data[i + 1] != null ? data[i + 1].length() : 0;
                this.columnWidths.put(data[i], Math.max(oldWidth, valueLength));
            }
            this.rows.add(row);
            return row;
        }

        public Map<String, String> appendData(String ... data) {
            if (data.length % 2 != 0) {
                throw new IllegalArgumentException("Uneven number of args " + data.length);
            }
            if (this.rows.size() == 0) {
                this.appendRow(new String[0]);
            }
            Map<String, String> row = this.rows.get(this.rows.size() - 1);
            for (int i = 0; i < data.length; i += 2) {
                row.put(data[i], data[i + 1]);
                int oldWidth = this.columnWidths.containsKey(data[i]) ? this.columnWidths.get(data[i]) : 0;
                this.columnWidths.put(data[i], Math.max(oldWidth, data[i + 1].length()));
            }
            return row;
        }

        @Override
        public Iterator<Map<String, String>> iterator() {
            return this.rows.iterator();
        }

        public int columnWidth(String col) {
            return this.columnWidths.containsKey(col) ? this.columnWidths.get(col) : 0;
        }
    }
}

