/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.i18n;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

@QAInfo(level=QAInfo.Level.PEDANTIC, state=QAInfo.State.QA_NEEDED)
public class EscapeUTF8Stream
extends InputStream {
    private static final int BUFFER_SIZE = 20;
    private int[] buffer = new int[20];
    private int bufferLength = 0;
    private int[] markBuffer = new int[20];
    private int markBufferLength = 0;
    private InputStream in;
    private InputStreamReader reader;

    public EscapeUTF8Stream(InputStream in) {
        this.in = in;
        try {
            this.reader = new InputStreamReader(in, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Exception creating InputStreamreader with charset 'utf-8'", e);
        }
    }

    public EscapeUTF8Stream(InputStream in, String charsetName) throws UnsupportedEncodingException {
        this.in = in;
        this.reader = new InputStreamReader(in, charsetName);
    }

    @Override
    @QAInfo(level=QAInfo.Level.PEDANTIC, state=QAInfo.State.QA_NEEDED)
    public int read() throws IOException {
        if (this.bufferLength > 0) {
            return this.buffer[--this.bufferLength];
        }
        int value = this.reader.read();
        if (value == -1) {
            return -1;
        }
        if (value <= 127) {
            return value;
        }
        String escaped = Integer.toHexString(value);
        while (escaped.length() < 4) {
            escaped = "0" + escaped;
        }
        byte[] temp = escaped.getBytes();
        this.buffer[0] = temp[3];
        this.buffer[1] = temp[2];
        this.buffer[2] = temp[1];
        this.buffer[3] = temp[0];
        this.buffer[4] = 117;
        this.bufferLength = 5;
        return 92;
    }

    @Override
    public int available() throws IOException {
        return this.bufferLength + this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.bufferLength = 0;
        this.reader.close();
        this.in.close();
    }

    @Override
    public void mark(int readLimit) {
        try {
            this.reader.mark(readLimit - this.bufferLength);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not mark with read ahead " + readLimit);
        }
        System.arraycopy(this.buffer, 0, this.markBuffer, 0, this.buffer.length);
        this.markBufferLength = this.bufferLength;
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
        System.arraycopy(this.markBuffer, 0, this.buffer, 0, this.buffer.length);
        this.bufferLength = this.markBufferLength;
    }

    @Override
    public long skip(long n) throws IOException {
        long read;
        for (read = 0L; read < n; ++read) {
            try {
                if (this.read() != -1) continue;
                return read;
            }
            catch (EOFException e) {
                return read;
            }
        }
        return read;
    }

    @Override
    @QAInfo(level=QAInfo.Level.PEDANTIC, state=QAInfo.State.QA_NEEDED)
    public int read(byte[] b) throws IOException {
        int read;
        for (read = 0; read < b.length; ++read) {
            try {
                int value = this.read();
                if (value == -1) {
                    return read;
                }
                b[read] = (byte)value;
                continue;
            }
            catch (EOFException e) {
                return read;
            }
        }
        return read;
    }
}

