/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.i18n;

import dk.statsbiblioteket.util.i18n.BundleCache;
import dk.statsbiblioteket.util.i18n.EmptyResourceBundle;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class Translator {
    public static final String DEFAULT_BUNDLE = "messages";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private ResourceBundle bundle;
    private Locale locale;
    private MessageFormat formatter;
    private HashMap<String, String> unknownMessages;
    private Log log;
    private boolean usingFallBack;

    public Translator(String bundleName, Locale locale) {
        this.locale = locale;
        this.formatter = new MessageFormat("", locale);
        this.unknownMessages = new HashMap();
        this.log = LogFactory.getLog(Translator.class);
        try {
            this.bundle = BundleCache.getBundle(bundleName, locale);
            this.usingFallBack = false;
        }
        catch (MissingResourceException e) {
            this.usingFallBack = true;
            this.log.warn("Unable to find resource bundle '" + bundleName + "' for locale '" + locale + "'. Trying default: '" + DEFAULT_LOCALE + "'.");
            try {
                this.bundle = BundleCache.getBundle(bundleName, DEFAULT_LOCALE);
            }
            catch (MissingResourceException ee) {
                this.log.warn("Unable to load bundle '" + bundleName + "' for default locale '" + DEFAULT_LOCALE + "'. Falling back to raw translations.");
                this.bundle = new EmptyResourceBundle();
            }
        }
    }

    public Translator(Locale locale) {
        this(DEFAULT_BUNDLE, locale);
    }

    public String translate(String key, Object ... values) {
        String message;
        block2: {
            try {
                message = this.bundle.getString(key);
            }
            catch (MissingResourceException e) {
                message = this.unknownMessages.get(key);
                if (message != null) break block2;
                this.log.warn("Unknown key '" + key + "' falling back to raw format" + ". This warning will only be logged once.");
                message = key.replace('.', ' ');
                this.unknownMessages.put(key, message);
            }
        }
        this.formatter.applyPattern(message);
        return this.formatter.format(values);
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

