/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.qa;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
class DynamicClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 2048;

    public DynamicClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(File baseDir, String classPath) throws IOException {
        int len;
        int classPosition = 6;
        if (!classPath.endsWith(".class")) {
            throw new IllegalArgumentException("Argument is not a class file");
        }
        File classFile = new File(baseDir, classPath);
        if (!classFile.isFile() || !classFile.exists()) {
            throw new FileNotFoundException(classFile + " not a file or " + " does not exist");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        FileInputStream file = new FileInputStream(classFile);
        byte[] buffer = new byte[2048];
        while ((len = file.read(buffer)) > 0) {
            bytes.write(buffer, 0, len);
        }
        String className = classPath.substring(0, classPath.length() - 6);
        className = className.replace(File.separator, ".");
        byte[] classData = bytes.toByteArray();
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass == null) {
            loadedClass = this.defineClass(className, classData, 0, classData.length);
        }
        return loadedClass;
    }
}

