/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.qa;

import dk.statsbiblioteket.util.Strings;
import dk.statsbiblioteket.util.qa.DynamicClassLoader;
import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.qa.Report;
import dk.statsbiblioteket.util.qa.ReportElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.QA_NEEDED, author="mke", revision="$Id: PackageScanner.java,v 1.10 2007/12/04 13:22:01 mke Exp $")
public class PackageScanner {
    private DynamicClassLoader loader = new DynamicClassLoader(ClassLoader.getSystemClassLoader());
    private File baseSource;
    private String target;
    private Report report;
    private Log log;

    public PackageScanner(Report finalReport, File baseDir, String className) {
        this.report = finalReport;
        this.baseSource = baseDir;
        this.target = className;
        this.log = LogFactory.getLog(PackageScanner.class);
    }

    public PackageScanner(Report finalReport, File baseDir) {
        this(finalReport, baseDir, "");
    }

    public final void scan() throws IOException {
        this.scan(this.target);
    }

    protected final void scan(String source) throws IOException {
        if (source == null) {
            throw new NullPointerException("Source argument is null");
        }
        File sourceFile = new File(this.baseSource, source);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFile.toString());
        }
        if (sourceFile.isFile()) {
            this.scanFile(source);
        } else {
            this.scanDirectory(source);
        }
    }

    @QAInfo(comment="This should not be printed since QA is ok", state=QAInfo.State.QA_OK)
    private void scanDirectory(String source) throws IOException {
        File sourceFile = new File(this.baseSource, source);
        if (sourceFile.isFile()) {
            throw new IllegalArgumentException("Argument must be a directory");
        }
        for (String child : sourceFile.list()) {
            if (!"".equals(source)) {
                this.scan(source + File.separator + child);
                continue;
            }
            this.scan(child);
        }
    }

    @QAInfo(comment="Annotation test comment.", deadline="Annotation test deadline", reviewers={"John Doe", "Homer Simpson"}, author="Darth V")
    private void scanFile(String source) throws IOException {
        File sourceFile = new File(this.baseSource, source);
        if (!sourceFile.isFile()) {
            throw new IllegalArgumentException("Argument must be a regular file");
        }
        try {
            ReportElement[] elts;
            Class classTarget = this.loader.loadClass(this.baseSource, source);
            for (ReportElement elt : elts = this.analyzeClass(classTarget, source.replace(".class", ".java"))) {
                this.report.add(elt);
            }
        }
        catch (Throwable t) {
            ReportElement error = new ReportElement(ReportElement.ElementType.ERROR, "Unknown class name", null, this.baseSource.toString(), source, null);
            String data = "Message: " + t.getMessage() + "\n\n" + "Stacktrace:\n" + Strings.getStackTrace(t);
            error.setData(data);
            this.report.add(error);
        }
    }

    public final ReportElement[] analyzeClass(Class classTarget, String filename) {
        Class<?>[] classes = classTarget.getDeclaredClasses();
        Constructor<?>[] constructors = classTarget.getDeclaredConstructors();
        Method[] methods = classTarget.getDeclaredMethods();
        Field[] fields = classTarget.getDeclaredFields();
        ArrayList<ReportElement> elements = new ArrayList<ReportElement>();
        ReportElement topLevel = new ReportElement(ReportElement.ElementType.CLASS, classTarget.getName(), null, this.baseSource.toString(), filename, classTarget.getAnnotation(QAInfo.class));
        elements.add(topLevel);
        for (Class<?> clazz : classes) {
            ReportElement classInfo = new ReportElement(ReportElement.ElementType.CLASS, clazz.getName(), classTarget.getName(), this.baseSource.toString(), filename, clazz.getAnnotation(QAInfo.class));
            elements.add(classInfo);
        }
        for (GenericDeclaration genericDeclaration : constructors) {
            ReportElement conInfo = new ReportElement(ReportElement.ElementType.METHOD, ((Constructor)genericDeclaration).getName().substring(((Constructor)genericDeclaration).getName().lastIndexOf(".") + 1), classTarget.getName(), this.baseSource.toString(), filename, ((Constructor)genericDeclaration).getAnnotation(QAInfo.class));
            elements.add(conInfo);
        }
        for (GenericDeclaration genericDeclaration : methods) {
            ReportElement metInfo = new ReportElement(ReportElement.ElementType.METHOD, ((Method)genericDeclaration).getName(), classTarget.getName(), this.baseSource.toString(), filename, ((Method)genericDeclaration).getAnnotation(QAInfo.class));
            elements.add(metInfo);
        }
        for (AnnotatedElement annotatedElement : fields) {
            ReportElement fInfo = new ReportElement(ReportElement.ElementType.FIELD, ((Field)annotatedElement).getName(), classTarget.getName(), this.baseSource.toString(), filename, ((Field)annotatedElement).getAnnotation(QAInfo.class));
            elements.add(fInfo);
        }
        return elements.toArray(new ReportElement[elements.size()]);
    }
}

