/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.qa;

import dk.statsbiblioteket.util.Files;
import dk.statsbiblioteket.util.qa.BasicReport;
import dk.statsbiblioteket.util.qa.HTMLReport;
import dk.statsbiblioteket.util.qa.PackageScanner;
import dk.statsbiblioteket.util.qa.Report;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class PackageScannerDriver {
    private PackageScannerDriver() {
    }

    private static void printHelp(Options options) {
        String usage = "java -jar qaScan.jar [options] <files|directories>";
        String msg = "\nAll provided directories will scanned recursively for class files. The class files found will be assumed to be belong to a package structure rooted at the provided directory.\n";
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(usage, msg, options, "2");
    }

    public static void main(String[] args) throws IOException {
        CommandLine cli = null;
        String[] targets = null;
        PosixParser cliParser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "Print help message and exit");
        options.addOption("n", "name", true, "Project name, default 'Unknown'");
        options.addOption("o", "output", true, "Type of output, 'plain' or 'html', default is html");
        options.addOption("p", "package", true, "Only scan a particular package in input dirs, use dotted package notation to refine selections");
        options.addOption("s", "source-dir", true, "Base source dir to use in report, can be a URL. @FILE@ and @MODULE@ will be escaped");
        try {
            cli = cliParser.parse(options, args);
            targets = cli.getArgs();
            if (args.length == 0 || targets.length == 0 || cli.hasOption("help")) {
                throw new ParseException("Not enough arguments, no input files");
            }
        }
        catch (ParseException e) {
            PackageScannerDriver.printHelp(options);
            System.exit(1);
        }
        String reportType = cli.getOptionValue("output") != null ? cli.getOptionValue("output") : "html";
        String projectName = cli.getOptionValue("name") != null ? cli.getOptionValue("name") : "Unknown";
        String baseSrcDir = cli.getOptionValue("source-dir") != null ? cli.getOptionValue("source-dir") : System.getProperty("user.dir");
        String targetPackage = cli.getOptionValue("package") != null ? cli.getOptionValue("package") : "";
        targetPackage = targetPackage.replace(".", File.separator);
        Report report = "plain".equals(reportType) ? new BasicReport() : new HTMLReport(projectName, System.out, baseSrcDir);
        for (String target : targets) {
            File f = new File(target);
            PackageScanner scanner = f.isDirectory() ? new PackageScanner(report, f, targetPackage) : new PackageScanner(report, f.getParentFile(), Files.baseName(f));
            scanner.scan();
        }
        report.end();
    }
}

