/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.qa;

import dk.statsbiblioteket.util.qa.QAInfo;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class ReportElement {
    private ElementType type;
    private QAInfo qaInfo;
    private String name;
    private String parent;
    private String filename;
    private String baseSourceDir;
    private String data;

    public ReportElement(ElementType type, String name, String parent, String baseSourceDir, String filename, QAInfo qaInfo) {
        this.type = type != null ? type : ElementType.UNDEFINED;
        this.name = name;
        this.parent = parent;
        this.baseSourceDir = baseSourceDir;
        this.filename = filename;
        this.qaInfo = qaInfo;
        this.data = null;
    }

    public final QAInfo getQAInfo() {
        return this.qaInfo;
    }

    public final ElementType getType() {
        return this.type;
    }

    public final String getShortName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    public final String getName() {
        if (this.parent != null) {
            return this.parent + "#" + this.name;
        }
        return this.name;
    }

    public final String getParent() {
        return this.parent;
    }

    public final String getBaseDir() {
        return this.baseSourceDir;
    }

    public final String getFilename() {
        return this.filename;
    }

    public final String toString() {
        String res = "<" + (Object)((Object)this.type) + "> " + this.getName() + "\n";
        res = res + "\tfile: " + this.filename;
        res = this.qaInfo == null ? res + "\n\tNo QAInfo" : res + "\n\t" + this.qaInfo.toString().replace(", ", ",\n\t\t").replace("(", "(\n\t\t");
        if (this.data != null) {
            res = res + "\n\t" + this.data.replace("\n", "\n\t\t");
        }
        return res;
    }

    public final void setData(String s) {
        this.data = s;
    }

    public final String getData() {
        return this.data;
    }

    public static enum ElementType {
        UNDEFINED,
        CLASS,
        METHOD,
        FIELD,
        ERROR;

    }
}

