/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.reader;

import java.io.IOException;
import java.io.Reader;

public class CharSequenceReader
extends Reader {
    private CharSequence seq;
    private int cursor;

    public CharSequenceReader(CharSequence seq) {
        if (seq == null) {
            throw new NullPointerException("Input CharSequence is null");
        }
        this.setSource(seq);
    }

    public CharSequenceReader setSource(CharSequence seq) {
        if (seq == null) {
            throw new NullPointerException("Can not reset internal CharSequence to null");
        }
        this.seq = seq;
        this.cursor = 0;
        return this;
    }

    @Override
    public int read(char[] chars, int offset, int count) throws IOException {
        if (this.seq == null) {
            throw new IOException("Reading from a closed CharSequenceReader");
        }
        int len = this.seq.length();
        int start = this.cursor;
        while (this.cursor < len && this.cursor - start < count && this.cursor - start + offset < chars.length) {
            chars[this.cursor - start + offset] = this.seq.charAt(this.cursor);
            ++this.cursor;
        }
        if (start == this.cursor) {
            return -1;
        }
        return this.cursor - start;
    }

    @Override
    public int read() {
        if (this.cursor == this.seq.length()) {
            return -1;
        }
        char next = this.seq.charAt(this.cursor);
        ++this.cursor;
        return next;
    }

    @Override
    public void close() throws IOException {
        this.seq = null;
    }
}

