/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.reader;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te, mke", comment="Lots of room for performance-improvements (basically for all iterative usages as arrayCopy is much more efficient). The Reader-compatible and Query-compatible methods are largely untested")
public class CircularCharBuffer
implements CharSequence,
Iterable<Character> {
    private static final int GROWTH_FACTOR = 2;
    private int max;
    private int first = 0;
    private int next = 0;
    private char[] array;

    public CircularCharBuffer(int initialSize, int maxSize) {
        this.array = new char[initialSize];
        this.max = maxSize;
        if (this.max != Integer.MAX_VALUE) {
            ++this.max;
        }
    }

    public void put(char c) {
        if (this.size() == this.array.length - 1) {
            this.extendCapacity();
        }
        this.array[this.next++] = c;
        this.next %= this.array.length;
    }

    public void put(char[] chars) {
        for (char c : chars) {
            this.put(c);
        }
    }

    public void put(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            this.put(s.charAt(i));
        }
    }

    public int read() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.take();
    }

    public char take() {
        if (this.first == this.next) {
            throw new NoSuchElementException("take() called on empty buffer");
        }
        char result = this.array[this.first++];
        if (this.first == this.array.length) {
            this.first = 0;
        }
        return result;
    }

    public int getMaximumCapacity() {
        return this.max == Integer.MAX_VALUE ? this.max : this.max - 1;
    }

    public int read(char[] cbuf, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if (this.size() == 0) {
            return -1;
        }
        if (this.first < this.next) {
            int moved = Math.min(len, this.next - this.first);
            System.arraycopy(this.array, this.first, cbuf, off, moved);
            this.first += moved;
            return moved;
        }
        int moved = Math.min(len, this.array.length - this.first);
        System.arraycopy(this.array, this.first, cbuf, off, moved);
        this.first += moved;
        if (this.first == this.array.length) {
            this.first = 0;
        }
        if (moved == len || this.size() == 0) {
            return moved;
        }
        int movedExtra = Math.min(len - moved, this.next - this.first);
        System.arraycopy(this.array, this.first, cbuf, off + moved, movedExtra);
        this.first += movedExtra;
        return moved + movedExtra;
    }

    public int read(CircularCharBuffer other, int len) {
        int counter;
        for (counter = 0; this.size() > 0 && counter < len; ++counter) {
            other.put(this.take());
        }
        if (len == 0) {
            return 0;
        }
        return counter == 0 ? -1 : counter;
    }

    public char[] takeAll() {
        int size = this.size();
        char[] result = new char[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.take();
        }
        return result;
    }

    public String takeString() {
        int size = this.size();
        StringWriter sw = new StringWriter(size);
        for (int i = 0; i < size; ++i) {
            sw.append(this.take());
        }
        return sw.toString();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            b.append(this.peek(i));
        }
        return b.toString();
    }

    public char peek(int ahead) {
        if (ahead >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Requesting a peek(" + ahead + ") when the size is only " + this.size());
        }
        return this.array[(this.first + ahead) % this.array.length];
    }

    public void clear() {
        this.first = 0;
        this.next = 0;
    }

    public int size() {
        if (this.first <= this.next) {
            return this.next - this.first;
        }
        return this.array.length - this.first + this.next;
    }

    private void extendCapacity() {
        if (this.array.length == this.max) {
            throw new ArrayIndexOutOfBoundsException("The buffer if full and cannot be expanded further");
        }
        int newSize = Math.min(this.max, Math.max(this.array.length + 1, this.array.length * 2));
        char[] newArray = new char[newSize];
        if (this.next == this.first) {
            this.array = newArray;
            return;
        }
        if (this.next < this.first) {
            System.arraycopy(this.array, this.first, newArray, 0, this.array.length - this.first);
            System.arraycopy(this.array, 0, newArray, this.array.length - this.first, this.next);
        } else {
            System.arraycopy(this.array, 0, newArray, this.first, this.next - this.first);
        }
        int oldSize = this.size();
        this.array = newArray;
        this.first = 0;
        this.next = oldSize;
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public char charAt(int n) {
        return this.peek(n);
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        block0: for (int pos = fromIndex; pos < this.size() - str.length() + 1; ++pos) {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != this.charAt(pos + i)) continue block0;
            }
            return pos;
        }
        return -1;
    }

    @Override
    public CircularCharBuffer subSequence(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException(String.format("Ending point, %s, is before starting point, %s, for subsequence", end, start));
        }
        if (start < 0) {
            throw new IllegalArgumentException("Starting point for subSequence is negative: " + start);
        }
        if (end > this.length()) {
            throw new ArrayIndexOutOfBoundsException("Ending point of subSequence is past buffer end: " + end);
        }
        CircularCharBuffer child = new CircularCharBuffer(this.length(), this.getMaximumCapacity());
        for (int i = start; i < end; ++i) {
            child.put(this.charAt(i));
        }
        return child;
    }

    public boolean add(Character character) {
        this.put(character.charValue());
        return true;
    }

    public boolean offer(Character character) {
        try {
            this.put(character.charValue());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Character remove() {
        return Character.valueOf(this.take());
    }

    public Character poll() {
        if (this.isEmpty()) {
            return null;
        }
        return Character.valueOf(this.take());
    }

    public Character element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("element() called on empty buffer");
        }
        return this.peek();
    }

    public Character peek() {
        if (this.isEmpty()) {
            return null;
        }
        return Character.valueOf(this.peek(0));
    }

    @Override
    public boolean isEmpty() {
        return this.first == this.next;
    }

    public boolean contains(Object o) {
        if (o == null || !(o instanceof Character)) {
            return false;
        }
        Character c = (Character)o;
        for (int i = 0; i < this.size(); ++i) {
            if (!c.equals(Character.valueOf(this.charAt(i)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CircularCharBufferIterator();
    }

    public Object[] toArray() {
        Object[] result = new Character[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = Character.valueOf(this.charAt(i));
        }
        return result;
    }

    public void close() {
        this.clear();
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Mark not supported (readAheadLimit given: " + readAheadLimit + ")");
    }

    public boolean markSupported() {
        return false;
    }

    public int read(CharBuffer target) {
        int count = 0;
        while (!this.isEmpty()) {
            target.put(this.take());
            ++count;
        }
        return count == 0 ? -1 : count;
    }

    public boolean ready() {
        return true;
    }

    public void reset() throws IOException {
        throw new IOException("Mark not supported, so reset is not supported");
    }

    public void skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip(" + n + ") failed: Only positive skips allowed");
        }
        int oldSize = this.size();
        if (n > (long)oldSize) {
            this.clear();
            throw new IOException("skip(" + n + ") called with only " + oldSize + " available chars. Buffer is cleared");
        }
        int i = 0;
        while ((long)i < n) {
            this.take();
            ++i;
        }
    }

    private class CircularCharBufferIterator
    implements Iterator<Character> {
        private int pos = 0;

        private CircularCharBufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < CircularCharBuffer.this.size();
        }

        @Override
        public Character next() {
            return Character.valueOf(CircularCharBuffer.this.charAt(this.pos++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

