/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.reader;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.reader.CircularCharBuffer;
import dk.statsbiblioteket.util.reader.TextTransformer;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public abstract class ReplaceReader
extends FilterReader
implements TextTransformer,
Cloneable {
    protected CircularCharBuffer sourceBuffer = null;

    public ReplaceReader(Reader reader) {
        super(ReplaceReader.dummyIfNull(reader));
        this.in = reader;
        this.sourceBuffer = null;
    }

    private static Reader dummyIfNull(Reader reader) {
        return reader == null ? new StringReader("") : reader;
    }

    @Override
    public ReplaceReader setSource(Reader source) {
        this.in = source;
        this.sourceBuffer = null;
        return this;
    }

    @Override
    public ReplaceReader setSource(CircularCharBuffer charBuffer) {
        this.sourceBuffer = charBuffer;
        this.in = null;
        return this;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.in != null) {
            this.in.close();
        }
    }

    public abstract Object clone();
}

