/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.rpc;

public class ConnectionContext<E> {
    private E con;
    private int refCount;
    private long lastUse;
    private String connectionId;

    ConnectionContext(E connection, String connectionId) {
        this.con = connection;
        this.refCount = 0;
        this.lastUse = System.currentTimeMillis();
        this.connectionId = connectionId;
    }

    public synchronized ConnectionContext<E> ref() {
        ++this.refCount;
        this.lastUse = System.currentTimeMillis();
        return this;
    }

    public synchronized void unref() {
        --this.refCount;
        this.lastUse = System.currentTimeMillis();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public synchronized int getRefCount() {
        return this.refCount;
    }

    synchronized long getLastUse() {
        return this.lastUse;
    }

    public synchronized E getConnection() {
        this.lastUse = System.currentTimeMillis();
        return this.con;
    }
}

