/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.rpc;

import dk.statsbiblioteket.util.rpc.ConnectionContext;
import dk.statsbiblioteket.util.rpc.ConnectionFactory;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager<E> {
    private int lingerTime;
    private ConnectionFactory<? extends E> connFactory;
    private HashMap<String, ConnectionContext<E>> connections;
    private Log log;
    private ConnectionMonitor<E> connectionMonitor;
    private boolean isClosed;

    public ConnectionManager(ConnectionFactory<? extends E> connFact) {
        if (connFact == null) {
            throw new NullPointerException("ConnectionFactory is null");
        }
        this.log = LogFactory.getLog(ConnectionManager.class);
        this.connFactory = connFact;
        this.connections = new HashMap();
        this.isClosed = false;
        this.setLingerTime(10);
        this.connectionMonitor = new ConnectionMonitor(this);
    }

    public void setLingerTime(int seconds) {
        if (this.isClosed) {
            throw new IllegalStateException("Manager is closed");
        }
        this.lingerTime = seconds;
    }

    public int getLingerTime() {
        return this.lingerTime;
    }

    public Collection<ConnectionContext<E>> getConnections() {
        return this.connections.values();
    }

    private synchronized void purgeConnection(String connectionId) {
        if (this.isClosed) {
            throw new IllegalStateException("Manager is closed");
        }
        if (connectionId == null) {
            throw new NullPointerException("connectionId is null");
        }
        ConnectionContext<E> ctx = this.connections.get(connectionId);
        if (ctx == null) {
            this.log.warn("Cannot purge unknown service '" + connectionId + "'");
            return;
        }
        if (ctx.getRefCount() > 0) {
            this.log.warn("Ignoring request to purge '" + connectionId + "'" + " with positive refCount " + ctx.getRefCount());
            return;
        }
        this.connections.remove(connectionId);
        this.log.debug("Purged connection '" + connectionId + "', " + this.connections.size() + " cached");
    }

    public synchronized ConnectionContext<E> get(String connectionId) {
        if (this.isClosed) {
            throw new IllegalStateException("Manager is closed");
        }
        if (!this.connectionMonitor.isRunning()) {
            this.log.trace("First connection request. Starting connection monitor");
            this.connectionMonitor.runInThread();
        }
        if (connectionId == null) {
            throw new NullPointerException("connectionId is null");
        }
        ConnectionContext<E> ctx = this.connections.get(connectionId);
        if (ctx == null) {
            this.log.debug("No connection to '" + connectionId + "' in cache");
            E conn = this.connFactory.createConnection(connectionId);
            if (conn == null) {
                return null;
            }
            ctx = new ConnectionContext<E>(conn, connectionId);
            this.log.trace("Adding new context for '" + connectionId + "' to cache");
            this.connections.put(connectionId, ctx);
        } else {
            this.log.debug("Found connection to '" + connectionId + "' in cache");
        }
        ctx.ref();
        return ctx;
    }

    public synchronized void release(ConnectionContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ConnectionContext is null");
        }
        ctx.unref();
    }

    public void reportError(ConnectionContext ctx, Throwable t) {
        if (ctx == null) {
            throw new NullPointerException("ConnectionContext is null");
        }
        this.log.debug("Error reported on '" + ctx.getConnectionId() + "'. Removing connection" + ". Error was:", t);
        this.connections.remove(ctx.getConnectionId());
    }

    public void reportError(ConnectionContext ctx, String msg) {
        if (ctx == null) {
            throw new NullPointerException("ConnectionContext is null");
        }
        this.log.debug("Error reported on '" + ctx.getConnectionId() + "'. Removing connection" + ". Error was: " + msg);
        this.connections.remove(ctx.getConnectionId());
    }

    public boolean checkError(ConnectionContext ctx, Throwable t) {
        if (t instanceof SocketException || t.getCause() instanceof SocketException) {
            this.reportError(ctx, t);
            return true;
        }
        return false;
    }

    public void close() {
        this.log.debug("Closed");
        this.connectionMonitor.stop();
        this.connections.clear();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class ConnectionMonitor<T>
    implements Runnable {
        private ConnectionManager<T> owner;
        private Log log;
        private boolean mayRun;
        private Thread thread;

        private ConnectionMonitor(ConnectionManager<T> owner) {
            this.owner = owner;
            this.log = LogFactory.getLog(ConnectionMonitor.class);
            this.mayRun = true;
        }

        public synchronized void stop() {
            this.log.debug("Stopped");
            this.mayRun = false;
            this.notify();
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.log.trace("Joining monitor thread");
                    this.thread.join();
                    this.log.trace("Monitor thread join complete");
                }
                catch (InterruptedException e) {
                    this.log.warn("Interrupted while waiting for monitor thread", e);
                }
            }
        }

        public synchronized void runInThread() {
            this.thread = new Thread((Runnable)this, this.getClass().getSimpleName());
            this.thread.setDaemon(true);
            this.log.trace("Starting connection manager thread");
            this.thread.start();
        }

        public synchronized boolean isRunning() {
            return this.thread != null;
        }

        @Override
        public void run() {
            this.log.trace("Starting with linger time: " + this.owner.getLingerTime());
            while (this.mayRun) {
                try {
                    Thread.sleep(this.owner.getLingerTime() * 1000);
                }
                catch (InterruptedException e) {
                    this.log.warn("Interrupted. Forcing connection scan.");
                }
                long now = System.currentTimeMillis();
                this.log.trace("Doing connection scan of " + this.owner.getConnections().size() + " connections");
                long timeout = this.owner.getLingerTime() * 1000;
                for (ConnectionContext<T> ctx : this.owner.getConnections()) {
                    long inactiveTime = now - ctx.getLastUse();
                    if (inactiveTime > timeout && ctx.getRefCount() == 0) {
                        this.log.debug("Connection " + ctx + " reached idle timeout.");
                        ((ConnectionManager)this.owner).purgeConnection(ctx.getConnectionId());
                        continue;
                    }
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("Connection " + ctx + " still active, timeout in " + (timeout - inactiveTime) + "ms " + "and refCount: " + ctx.getRefCount());
                }
                this.log.trace("Connection scan complete. " + this.owner.getConnections().size() + " connections remaining in cache");
            }
            this.log.debug("Thread terminated");
        }
    }
}

