/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.xml;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.xml.DefaultNamespaceContext;
import dk.statsbiblioteket.util.xml.SynchronousXPathSelector;
import dk.statsbiblioteket.util.xml.XPathSelector;
import dk.statsbiblioteket.util.xml.XPathSelectorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te, mke")
public class DOM {
    private static Log log = LogFactory.getLog(DOM.class);
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final SynchronousXPathSelector selector = new SynchronousXPathSelector(null, 50);

    public static String getElementNodeValue(Node node) {
        StringWriter sw = new StringWriter(2000);
        if (node.getNodeType() == 1) {
            NodeList all = node.getChildNodes();
            for (int i = 0; i < all.getLength(); ++i) {
                if (all.item(i).getNodeType() != 3 && all.item(i).getNodeType() != 4) continue;
                sw.append(all.item(i).getNodeValue());
            }
        }
        return sw.toString();
    }

    public static Document stringToDOM(String xmlString, boolean namespaceAware) {
        try {
            InputSource in = new InputSource();
            in.setCharacterStream(new StringReader(xmlString));
            DocumentBuilderFactory dbFact = DocumentBuilderFactory.newInstance();
            dbFact.setNamespaceAware(namespaceAware);
            return dbFact.newDocumentBuilder().parse(in);
        }
        catch (IOException e) {
            log.warn("I/O error when parsing XML :" + e.getMessage() + "\n" + xmlString, e);
        }
        catch (SAXException e) {
            log.warn("Parse error when parsing XML :" + e.getMessage() + "\n" + xmlString, e);
        }
        catch (ParserConfigurationException e) {
            log.warn("Parser configuration error when parsing XML :" + e.getMessage() + "\n" + xmlString, e);
        }
        return null;
    }

    public static Document stringToDOM(String xmlString) {
        return DOM.stringToDOM(xmlString, false);
    }

    public static Document streamToDOM(InputStream xmlStream, boolean namespaceAware) {
        try {
            DocumentBuilderFactory dbFact = DocumentBuilderFactory.newInstance();
            dbFact.setNamespaceAware(namespaceAware);
            return dbFact.newDocumentBuilder().parse(xmlStream);
        }
        catch (IOException e) {
            log.warn("I/O error when parsing stream :" + e.getMessage(), e);
        }
        catch (SAXException e) {
            log.warn("Parse error when parsing stream :" + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            log.warn("Parser configuration error when parsing XML stream: " + e.getMessage(), e);
        }
        return null;
    }

    public static Document streamToDOM(InputStream xmlStream) {
        return DOM.streamToDOM(xmlStream, false);
    }

    public static String domToString(Node dom) throws TransformerException {
        return DOM.domToString(dom, false);
    }

    public static String domToString(Node dom, boolean withXmlDeclaration) throws TransformerException {
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("encoding", "UTF-8");
        if (withXmlDeclaration) {
            t.setOutputProperty("omit-xml-declaration", "no");
        } else {
            t.setOutputProperty("omit-xml-declaration", "yes");
        }
        t.setOutputProperty("method", "xml");
        StringWriter sw = new StringWriter();
        t.transform(new DOMSource(dom), new StreamResult(sw));
        return sw.toString();
    }

    public static XPathSelector createXPathSelector(String ... nsContext) {
        return new XPathSelectorImpl(new DefaultNamespaceContext(null, nsContext), 50);
    }

    public static Integer selectInteger(Node node, String xpath, Integer defaultValue) {
        return selector.selectInteger(node, xpath, defaultValue);
    }

    public static Integer selectInteger(Node node, String xpath) {
        return selector.selectInteger(node, xpath);
    }

    public static Double selectDouble(Node node, String xpath, Double defaultValue) {
        return selector.selectDouble(node, xpath, defaultValue);
    }

    public static Double selectDouble(Node node, String xpath) {
        return selector.selectDouble(node, xpath);
    }

    public static Boolean selectBoolean(Node node, String xpath, Boolean defaultValue) {
        return selector.selectBoolean(node, xpath, defaultValue);
    }

    public static Boolean selectBoolean(Node node, String xpath) {
        return selector.selectBoolean(node, xpath);
    }

    public static String selectString(Node node, String xpath, String defaultValue) {
        return selector.selectString(node, xpath, defaultValue);
    }

    public static String selectString(Node node, String xpath) {
        return selector.selectString(node, xpath);
    }

    public static NodeList selectNodeList(Node node, String xpath) {
        return selector.selectNodeList(node, xpath);
    }

    public static Node selectNode(Node dom, String xpath) {
        return selector.selectNode(dom, xpath);
    }

    static void clearXPathCache() {
        selector.clearCache();
    }
}

