/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.xml;

import dk.statsbiblioteket.util.Strings;
import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.reader.ReplaceFactory;
import dk.statsbiblioteket.util.reader.ReplaceReader;
import java.io.StringReader;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class XMLUtil {
    private static final ThreadLocal<ReplaceReader> localEncoder = new ThreadLocal<ReplaceReader>(){

        @Override
        protected ReplaceReader initialValue() {
            return ReplaceFactory.getReplacer("&", "&amp;", "\"", "&quot;", "<", "&lt;", ">", "&gt;", "'", "&apos;");
        }
    };

    public static String encode(String input) {
        ReplaceReader r = localEncoder.get();
        r.setSource(new StringReader(input));
        return Strings.flushLocal(r);
    }

    public static String eventID2String(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE ," + eventType;
    }
}

