/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.xml;

import dk.statsbiblioteket.util.xml.LRUCache;
import dk.statsbiblioteket.util.xml.XPathSelector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathSelectorImpl
implements XPathSelector {
    private static final Log log = LogFactory.getLog(XPathSelector.class);
    private static final XPath xpathCompiler = XPathFactory.newInstance().newXPath();
    private LRUCache<String, XPathExpression> cache;
    private NamespaceContext nsContext;

    public XPathSelectorImpl(NamespaceContext nsContext, int cacheSize) {
        this.nsContext = nsContext;
        this.cache = new LRUCache(cacheSize);
    }

    @Override
    public Integer selectInteger(Node node, String xpath, Integer defaultValue) {
        String strVal = this.selectString(node, xpath);
        if (strVal == null || "".equals(strVal)) {
            return defaultValue;
        }
        return Integer.valueOf(strVal);
    }

    @Override
    public Integer selectInteger(Node node, String xpath) {
        return this.selectInteger(node, xpath, null);
    }

    @Override
    public Double selectDouble(Node node, String xpath, Double defaultValue) {
        Double d = (Double)this.selectObject(node, xpath, XPathConstants.NUMBER);
        if (d == null || d.equals(Double.NaN)) {
            d = defaultValue;
        }
        return d;
    }

    @Override
    public Double selectDouble(Node node, String xpath) {
        return this.selectDouble(node, xpath, null);
    }

    @Override
    public Boolean selectBoolean(Node node, String xpath, Boolean defaultValue) {
        String tmp = this.selectString(node, xpath, null);
        if (tmp == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(tmp);
    }

    @Override
    public Boolean selectBoolean(Node node, String xpath) {
        return this.selectBoolean(node, xpath, false);
    }

    @Override
    public String selectString(Node node, String xpath, String defaultValue) {
        if ("".equals(defaultValue)) {
            return (String)this.selectObject(node, xpath, XPathConstants.STRING);
        }
        Node n = this.selectNode(node, xpath);
        if (n == null) {
            return defaultValue;
        }
        return (String)this.selectObject(node, xpath, XPathConstants.STRING);
    }

    @Override
    public String selectString(Node node, String xpath) {
        return this.selectString(node, xpath, "");
    }

    @Override
    public NodeList selectNodeList(Node dom, String xpath) {
        return (NodeList)this.selectObject(dom, xpath, XPathConstants.NODESET);
    }

    @Override
    public Node selectNode(Node dom, String xpath) {
        return (Node)this.selectObject(dom, xpath, XPathConstants.NODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object selectObject(Node dom, String xpath, QName returnType) {
        Object retval = null;
        try {
            XPathExpression exp = (XPathExpression)this.cache.get(xpath);
            if (exp == null) {
                XPath xPath = xpathCompiler;
                synchronized (xPath) {
                    if (this.nsContext != null) {
                        xpathCompiler.setNamespaceContext(this.nsContext);
                    }
                    exp = xpathCompiler.compile(xpath);
                    this.cache.put(xpath, exp);
                }
            }
            retval = exp.evaluate(dom, returnType);
        }
        catch (NullPointerException e) {
            log.debug(String.format("NullPointerException when extracting XPath '%s' on element type %s. Returning null", xpath, returnType.getLocalPart()), e);
        }
        catch (XPathExpressionException e) {
            log.warn(String.format("Error in XPath expression '%s' when selecting %s: %s", xpath, returnType.getLocalPart(), e.getMessage()), e);
        }
        return retval;
    }

    void clearCache() {
        this.cache.clear();
    }
}

