/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.xml;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.xml.NamespaceRemover;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class XSLT {
    private static Log warnlog = LogFactory.getLog(XSLT.class.getName() + "#warnings");
    private static Log log = LogFactory.getLog(XSLT.class);
    private static ErrorListener ERRORLISTENER;
    private static ThreadLocal<Map<String, Transformer>> localMapCache;
    static URL NAMESPACE_XSLT;

    public static Transformer createTransformer(URL xslt) throws TransformerException {
        Transformer transformer;
        log.debug("Requesting and compiling XSLT from '" + xslt + "'");
        TransformerFactory tfactory = TransformerFactory.newInstance();
        InputStream in = null;
        try {
            if (xslt == null) {
                throw new NullPointerException("xslt URL is null");
            }
            in = xslt.openStream();
            transformer = tfactory.newTransformer(new StreamSource(in, xslt.toString()));
            transformer.setErrorListener(XSLT.getErrorListener());
        }
        catch (MalformedURLException e) {
            throw new TransformerException(String.format("The URL to the XSLT is not a valid URL: '%s'", xslt), e);
        }
        catch (IOException e) {
            throw new TransformerException(String.format("Unable to open the XSLT resource '%s'", xslt), e);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException(String.format("Wrongly configured transformer for XSLT at '%s'", xslt), e);
        }
        catch (TransformerException e) {
            throw new TransformerException("Unable to instantiate Transformer, a system configuration error?", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.warn("Non-fatal IOException while closing stream to '" + xslt + "'");
            }
        }
        return transformer;
    }

    private static ErrorListener getErrorListener() {
        if (ERRORLISTENER == null) {
            ERRORLISTENER = new ErrorListener(){

                @Override
                public void warning(TransformerException exception) throws TransformerException {
                    warnlog.debug("A transformer warning occured", exception);
                }

                @Override
                public void error(TransformerException exception) throws TransformerException {
                    throw new TransformerException("A Transformer error occured", exception);
                }

                @Override
                public void fatalError(TransformerException exception) throws TransformerException {
                    throw new TransformerException("A Transformer exception occured", exception);
                }
            };
        }
        return ERRORLISTENER;
    }

    private static ThreadLocal<Map<String, Transformer>> createLocalMapCache() {
        return new ThreadLocal<Map<String, Transformer>>(){

            @Override
            protected Map<String, Transformer> initialValue() {
                return new HashMap<String, Transformer>();
            }
        };
    }

    public static Transformer getLocalTransformer(URL xslt) throws TransformerException {
        return XSLT.getLocalTransformer(xslt, null);
    }

    public static Transformer getLocalTransformer(URL xslt, Map parameters) throws TransformerException {
        if (xslt == null) {
            throw new NullPointerException("The xslt was null");
        }
        Map<String, Transformer> map = localMapCache.get();
        Transformer transformer = map.get(xslt.toString());
        if (transformer == null) {
            transformer = XSLT.createTransformer(xslt);
            map.put(xslt.toString(), transformer);
        }
        transformer.clearParameters();
        if (parameters != null) {
            Iterator i$ = parameters.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entryObject;
                Map.Entry entry = entryObject = i$.next();
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        return transformer;
    }

    public static void clearTransformerCache() {
        localMapCache = XSLT.createLocalMapCache();
    }

    public static String transform(URL xslt, String in) throws TransformerException {
        return XSLT.transform(xslt, in, null, false);
    }

    public static String transform(URL xslt, String in, boolean ignoreXMLNamespaces) throws TransformerException {
        return XSLT.transform(xslt, in, null, ignoreXMLNamespaces);
    }

    public static String transform(URL xslt, String in, Map parameters) throws TransformerException {
        return XSLT.transform(xslt, in, parameters, false);
    }

    public static String transform(URL xslt, String in, Map parameters, boolean ignoreXMLNamespaces) throws TransformerException {
        StringWriter sw = new StringWriter();
        if (!ignoreXMLNamespaces) {
            XSLT.transform(xslt, (Reader)new StringReader(in), sw, parameters);
        } else {
            NamespaceRemover noNamespace = new NamespaceRemover(new StringReader(in));
            XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), (Reader)noNamespace, (Writer)sw);
        }
        return sw.toString();
    }

    public static String transform(URL xslt, Reader in, Map parameters) throws TransformerException {
        return XSLT.transform(xslt, in, parameters, false);
    }

    public static String transform(URL xslt, Reader in, Map parameters, boolean ignoreXMLNamespaces) throws TransformerException {
        StringWriter sw = new StringWriter();
        if (!ignoreXMLNamespaces) {
            XSLT.transform(xslt, in, sw, parameters);
        } else {
            XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), (Reader)new NamespaceRemover(in), (Writer)sw);
        }
        return sw.toString();
    }

    public static ByteArrayOutputStream transform(URL xslt, byte[] in, Map parameters) throws TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XSLT.transform(xslt, (InputStream)new ByteArrayInputStream(in), out, parameters);
        return out;
    }

    public static ByteArrayOutputStream transform(URL xslt, byte[] in, Map parameters, boolean ignoreXMLNamespaces) throws TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!ignoreXMLNamespaces) {
            XSLT.transform(xslt, (InputStream)new ByteArrayInputStream(in), out, parameters);
        } else {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            NamespaceRemover reader = new NamespaceRemover(new InputStreamReader(new ByteArrayInputStream(in)));
            XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), (Reader)reader, (Writer)writer);
        }
        return out;
    }

    public static ByteArrayOutputStream transform(URL xslt, InputStream in, Map parameters) throws TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), in, (OutputStream)out);
        return out;
    }

    public static ByteArrayOutputStream transform(URL xslt, InputStream in, Map parameters, boolean ignoreXMLNamespaces) throws TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!ignoreXMLNamespaces) {
            XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), in, (OutputStream)out);
        } else {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            NamespaceRemover reader = new NamespaceRemover(new InputStreamReader(in));
            XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), (Reader)reader, (Writer)writer);
        }
        return out;
    }

    public static ByteArrayOutputStream transform(URL xslt, Document dom, Map parameters) throws TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), dom, (OutputStream)out);
        return out;
    }

    public static void transform(URL xslt, InputStream in, OutputStream out, Map parameters) throws TransformerException {
        XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), in, out);
    }

    public static void transform(URL xslt, Reader in, Writer out, Map parameters) throws TransformerException {
        XSLT.transform(XSLT.getLocalTransformer(xslt, parameters), in, out);
    }

    public static void transform(Transformer transformer, Document dom, OutputStream out) throws TransformerException {
        transformer.transform(new DOMSource(dom), new StreamResult(out));
    }

    public static void transform(Transformer transformer, InputStream in, OutputStream out) throws TransformerException {
        transformer.transform(new StreamSource(in), new StreamResult(out));
    }

    public static void transform(Transformer transformer, Reader in, Writer out) throws TransformerException {
        transformer.transform(new StreamSource(in), new StreamResult(out));
    }

    public static void transform(Transformer transformer, Document dom, Writer out) throws TransformerException {
        transformer.transform(new DOMSource(dom), new StreamResult(out));
    }

    static {
        localMapCache = XSLT.createLocalMapCache();
        NAMESPACE_XSLT = Thread.currentThread().getContextClassLoader().getResource("dk/statsbiblioteket/util/xml/namespace_remover.xslt");
    }
}

